// computes f/subs(f,n=n-1) and returns a normalized result
// see also Koepf, Hypergeometric summation, page 15

sum::ratio :=
proc(f, n) 
  local p,a,b,i,res;
begin
  // not really correct, but best in practice:
  if iszero(f) then
    return(f)
  end_if;
  if not has(f, n) then
    return(1)
  end_if;
  case type(f)
    of "_mult" do
      return(normal(map(f,sum::ratio,n)))
    of "_power" do
      // special case
      if op(f, 1) = -1 then
        f:= Simplify::minus1Power(f);
        if type(f) <> "_power" then
          return(sum::ratio(f, n))
        end_if;
      end_if;
      if not has(op(f,2),n) then
        return(sum::ratio(op(f,1),n)^op(f,2))
      elif not has(op(f,1),n) then
        if traperror( ( res:= op(f,1)^(op(f,2)-subs(op(f,2),n=n-1)) ) 
                  ) = 0 then
          return(res);
        else
          // Here we have a special case a division by zero
          return(f);
        end_if:
      else
        break
      end_if
   of "fact" do
      if not has((p:=sum::ratio(rewrite(f,gamma),n)),gamma) then
        return(p)
      end_if;
      break
   of "gamma" do
      if not has(f,n) then
        return(1)
      elif sum::is_linear((p:=op(f)),n) then
        if type((a:=coeff(p,n,1)))=DOM_INT then
          b:=coeff(p,n,0);
          if a>0 then
            return(_mult(a*n+b-i$i=1..a))
          elif a<0 then
            return(1/eval(_mult(a*n+b+i$i=0..-a-1))) // PR-6
            // a cannot be 0 otherwise p would be independent of n 
          end_if
         end_if
      end_if;
   end_case;
   // other cases 
 
  if type(f) = "binomial" then
    return(sum::ratio(expand(f),n))
  end_if;
  if traperror( (res:=normal(f/expand(subs(f,n=n-1)))) ) = 0 and res <> undefined then
    res;
  else
    f;
  end_if;
end_proc:

sum::is_linear:=
proc(p,x) // checks for a*x+b
begin
  if testtype(p,Type::PolyExpr(x,Type::AnyType)) then
    if degree(p,x)=1 then
      return(TRUE)
    end_if
  end_if;
  FALSE
end_proc:
