sum::sum:=
proc(s: Type::Arithmetical, x, options: DOM_TABLE)
  local f,f_orig,newn,fnew, g,gg,_k_,Rec,RRec,u,_d_,l,lc, r, _p,n,q,z,clean,
  i, j, C, rewrite2exp, summe, lookupOnly, look, sums, nonsums, sup;

  save _X ;
begin
  if stdlib::hasfloat(s) then
    s:= numeric::rationalize(s);
    return(float(sum(s, x)))
  end_if;
   
  if options["LookupOnly"] = TRUE then
    lookupOnly := TRUE ;
    look := "LookupOnly" ;
  else
    lookupOnly := FALSE ;
    look := null() ;
  end_if:

 
  //-----------------------------------
  // special case kroneckerDelta: the patterns
  // contain only func(k)*kroneckerDelta(a*k + b, 0).
  // Make sure that kroneckerDelta(a*k + b , c*k + d)
  // are rewritten as kroneckerDelta((a - c)*k + b, 0)
  // matching this pattern
  //-----------------------------------
  if has(s, kroneckerDelta) then
     if type(x) = "_equal" then
        return(sum::kroneckerDeltaDefinite(s, x));
     else
        s:= subs(s, hold(kroneckerDelta) = proc(a, b)
                         begin
                           kroneckerDelta(collect(a - b, [x]), 0)
                    end_proc, EvalChanges):
     end_if;
  end_if;
  
  
  n:= if type(x) = DOM_IDENT or type(x) = "_index" then
        x
      else
        op(x, 1)
      end_if;

  rewrite2exp:= (f) -> (
      f:= misc::maprec(f, {"cos", "sin", "cosh", "sinh"} =
                       proc(X)
                         begin
                           if has(X, n) then
                             rewrite(X, exp)
                           else
                             X
                           end_if
                       end_proc);
      if has(f, exp) then
         f:= subs(f, hold(exp) = (x->`#E`^x),EvalChanges)
      end_if;
      f);

  clean:= x ->subs(x,`#E` = exp(1));

  f:= s;
  
  if domtype(x) = DOM_IDENT or type(x) = "_index" then
// to do: if f is a sum, try to sum the individual operands first
    f:= rewrite2exp(f):
    if f = undefined then
      return(undefined)
    end_if;
    f := sum::indefinite(f, x, look);
  elif type(x) = "_in" then
    // can only sum over finite sets and RootOf's at the moment
    // map to piecewises
    f:= rewrite2exp(f):
    if f = undefined then
      return(undefined)
    end_if;
    case type(op(x, 2))
      of RootOf do
        f:= sum::rootOf(op(x, 2), op(x, 1), s);
        if f = FAIL then
          return(hold(sum)(s, x))
        else
          return(f)
        end_if
      of DOM_SET do
        return(_plus(subs(s, op(x,1) = op(x, [2, j])) $j=1..nops(op(x, 2)) ))
      of piecewise do
        return(piecewise::extmap(op(x, 2), S -> sum(s, op(x, 1) in S)))
      otherwise
        if iszero(s) then
          return(s)
        else
          return(hold(sum)(s, x))
        end_if
    end_case;
  elif type(x)="_equal" then
    _k_:= op(x, 1);
    if type(op(x, 2))="_range" then
      // definite summation

      if map({op(op(x, 2))}, domtype) intersect
        {DOM_FLOAT, DOM_RAT, DOM_COMPLEX} <> {} then
        error("Illegal range")
      end_if;

      l:= op(x, [2, 1]);
      r:= op(x, [2, 2]);

      if l=r then // one-point range
        return(sum::myeval(s, _k_, l))
      end_if;

      // Insert the lookup mechanism before we try something else
      // So we have a lookup for definite summation
      C:=genident() ;
      delete _X;
      if _k_<>_X then f:=subs(f,[_X=C,_k_=_X]) end_if;
      
      userinfo(2,"trying the lookup method for definite summation");
      summe:=sum::lookup(f, _X, l, r);
      if summe<>FAIL then
        summe:=subs(summe, [_X=_k_,C=_X]) ;
        return(summe);
      else
        f:=subs(f, [_X=_k_,C=_X]) ;
      end_if;
      if lookupOnly then
        return(hold(sum)(f, x)) ;
      end_if:
      
      f:= rewrite2exp(f):
      if f = undefined then
        return(undefined)
      end_if;
      
      if domtype((g:= r - l)) = DOM_INT and g < options[hold(ExpandFinite)]
        then
        // finite range
        assert(g>=0);
        fnew:= eval(_plus(subs(s,_k_=u+l,EvalChanges) $ u=0..g));

        // if fnew is so simple that no improvement seems possible, return
        if testtype(fnew, Type::Numeric) then
          return(fnew)
        end_if;
        // otherwise, compare with result obtained by using indefinite summatio
        if traperror((g := sum::indefinite(f, _k_, look))) <> 0  
        or hastype(g, "sum") then
          return(fnew)
        end_if;
        
        g:= clean(g);
        if traperror(
                     (g:= sum::myeval(g,_k_,r+1)
                        - sum::myeval(g,_k_, l))
                     ) <>0 then
          return(fnew)
        end_if;
        // if (exp(10000) - 1)/(exp(x) - 1) is normalized, this can become very slow!
        // f:= normal(g);
        if traperror((f:= normal(g), MaxSteps = 3)) <> 0 or length(f) > length(g) then
          f:= g
        end_if;
        if length(fnew) < length(f) then
          return(fnew)
        else
          return(f)
        end_if         
        
      end_if;


      // extract constants
      case type(f)
        of "_plus" do
          g:= split(f, has, _k_);
          if not iszero(g[2]) then
            return((r+1 - l)*g[2] + sum::sum(g[1], x, options))
          end_if;
          break
        of "_mult" do
          g:= split(f, has, _k_);
          if g[2] <> 1 then
            return(g[2] * sum::sum(g[1], x, options))
          end_if;
          break
      end_case;

      
      // apply some heuristics for infinite ranges

      if l = -infinity and r = infinity then
        // as experience shows, splitting saves time here although
        // two sums have to be computed
        if not sum::ishypergeom(f,_k_) then
          return(sum::sum(f, _k_ = l .. -1, options) +
                 sum::sum(f, _k_ = 0 .. r, options))
        end_if;
      
      elif l = -infinity and not has(r, infinity) then
        // sums of the form \sum_{k=-\infty}^{n} f(k)
        // are normalized to \sum_{k=-n}^{\infty} f(-k)
        f:= subs(f, _k_= -_k_);
        l:= -r;
        r:= infinity;
        x:= _k_ = l .. r;
        return(sum::sum(f, x, options));
      end_if;

      if r = infinity and testtype(f, Type::RatExpr(_k_)) = TRUE then
        f:= normal(f);
        n:= degree((u:= numer(f)), [_k_]) - degree((q:= denom(f)), [_k_]);
        assert(type(n) = DOM_INT);
        u:= lcoeff(u, [_k_]);
        q:= lcoeff(q, [_k_]);
        if is(u<>0 and q<>0) = TRUE and n>= -1 then
          // the sum cannot converge
          lc:= u/q;
          if n mod 2 = 1 and l = -infinity then
            return(undefined)
          else
            return(sign(lc) * infinity)
          end_if
        end_if;
      end_if;

      // if f is a sum, try to sum the individual operands
      if type(f) = "_plus" then
        l:= map([op(f)], sum::sum, x, options);
        [sums, nonsums, C]:= split(l, X -> type(X) = "sum");
        assert(C= []);
        // write sum(f1, n) + sum(f2, n)  as sum(f1+f2, n)
        sums:= _plus(op(map(sums, op, 1)));
        if iszero(sums) then
          return(normal(_plus(op(nonsums))))
        end_if
      end_if; 
      
      g := sum::indefinite(f, _k_, look);
      if hastype(g, "sum") or hastype(g, "product") or
        piecewise::disregardPoints(g) = undefined then

        if type(f) = "_mult" then
          // do not use expand, since we only
          // want to expand products, but we
          // do not apply addition theorems for sin, cos, etc.
          l:= [op(f)];
          if (u:= contains(map(l, type), "_plus")) > 0 then
            q:= l[u];
            delete l[u];
            _mult(op(l));
            fnew:= _plus(op(q, i)*%  $i=1..nops(q))
          else
            fnew:= f
          end_if
        else
          fnew:= f;
        end_if;
        if type(fnew) = "_plus" then // try to map
        l := [];
          for q in fnew do
            u := sum::sum(q,x, options);
            if hastype(u, {"sum", "solve"}) then
            // no success: either an unevaluated sum
            // or an unsolved rec was returned  
              break
            else
              l := append(l, u)
            end_if
          end_for;
          if nops(l) = nops(fnew) then
            return(clean(_plus(op(l))));
          end_if;
        end_if;
        
        userinfo(1,"indefinite summation failed");
        if sum::ishypergeom(f,_k_) then
          userinfo(1,"summand is hypergeometric");
          // try Zeilberger's algorithm 
          // choose in priority indets that are in the bounds 
          l:= indets(op(x,2)) minus Type::ConstantIdents minus {`#E`};
          l:=[op(l), op((indets(f) minus Type::ConstantIdents minus {`#E`})
                        minus (l union {_k_}))];
          newn:= genident();
          for n in l do
            // replace n by newn where it cannot be helpful because
            // sum::ratio surely would not produce a rational expression in n
            // we may then compute the sum and substitute back, since n
            // is independent of the summation variable  
            f_orig:= f;
            f:= misc::maprec
            (f,
             (t -> not contains({"_power", "_plus", "_mult", DOM_IDENT,
                                "binomial", "fact", "gamma"}, type(t))) =
             (a -> subs(a, n = newn)),
             PostMap);
            f:= misc::maprec(f, {"_power"} =
                             (a -> subsop(a, 2 = subs(op(a, 2), n = newn))));
            if sum::ishypergeom(f,n) then
              userinfo(1,"trying Zeilberger's algorithm with respect to",n);
              u:= genident("u");
              Rec:= sum::zeilberger(f, _k_, n, u, op(op(x,2)), options);
              if Rec = FAIL then
                userinfo(1,"Zeilberger's algorithm fails");
                f:= f_orig;
                next
              else
                userinfo(1,"Zeilberger's algorithm succeeds")
              end_if;
              gg:=Rec[2]; RRec:=Rec[1];
              _d_:=op(RRec,[1,1])-n;
              if op(x,[2,1]) = -infinity or op(x,[2,2]) = infinity then
                sup:= op(x,1) = sum::support(f, _k_);
              else
                sup:= x ;
              end_if:
              _p:= proc(z)
                     name sum::sum; local wert ;
                   begin
                     wert:= subs(op(sup,2),n=z,EvalChanges) ;
                     if is(op(wert,1) <= op(wert,2)) = FALSE then
                       error("Left border must not exceed right border")
                     end_if;
                     subs( hold(sum)(f,_k_=op(sup,2)), n=z, EvalChanges )
                   end_proc;
              // it seems that more than one shift is necessary in
              // some cases
              g := FAIL;
              while (contains({is((op(sup, [2,1])<=op(sup, [2,2]))|n=z)$ z=gg-_d_..gg}, FALSE) or traperror((g:={(u(z)=_p(z))$ z=gg-_d_..gg}))<>0) and gg < Rec[2] + 20 do
                gg:= gg+1
              end_while;
              if g = FAIL then return(hold(sum)(s, x)); end_if;
              
              Rec:=solve(rec(RRec,u(n),g));
              Rec:= piecewise::extmap
                    (Rec,
                     proc(R)
                     begin
                      if R = {} then 
                         undefined
                      else
                         R
                      end_if;
                     end_proc);
              Rec:= eval(Rec):

              if Rec = undefined or 
                 type(Rec) = "solve" then
                // We specified one more initial condition than necessary in
                // the previous call.
                // ( This is necessary since otherwise, due to the changed
                //   output format of rec::solve, the
                //   solution returned by rec::solve may still contain free
                //   parameters ... CRUDE HACK!
                //   Example: sum(k*binomial(n, k), k = 0..n) )
                // Since it was not successful, it
                // sometimes helps to specify one less initial condition.
                // Example: sum(binomial(d,j)*binomial(d-r-j-1,r-j),j=0..r)
                // ( Reason: rec::solve uses linsolve which does not recognize
                //   the functional identity of the gamma function)
                if traperror((g:={(u(z)=_p(z))$ z=gg-_d_..gg-1}))<>0 then
                  g:={(u(z)=_p(z))$ z=gg-_d_+1..gg}
                end_if;
                Rec:=solve(rec(RRec,u(n),g));
              end_if:
              Rec:= piecewise::extmap
                    (Rec,
                     proc(R)
                     begin
                      if R = {} then 
                         undefined
                      else
                         R
                      end_if;
                     end_proc);
              Rec:= eval(Rec):

              userinfo(5, "Solving recurrence equation gives ".
                       expr2text(Rec));
              if not has(Rec,undefined) then
                Rec:= piecewise::extmap
                (Rec,
                 proc(Rc)
                 begin
                   if type(Rc)=DOM_SET and nops(Rc)>=1 then
                     op(Rc,1)
                   else
                     Rc
                   end_if
                 end_proc);
                delete _p;
                if has(Rec,solve) then
                  return(hold(sum)(s, x)) ;
                else
                  return(clean(subs(Rec, newn = n)))
                end_if;
              end_if;
              delete _p;
            end_if; // ishypergeom(f, n)
            f:= f_orig;
          end_for; // for n in l
          // f is hypergeometric but Zeilberger's algorithm fails 
          userinfo(1,"trying definite summation of hypergeometrics");
          g:=sum::hypergeomtype(f,_k_);
          if g<>FAIL then
             g:= clean(op(g, 1)), clean(op(g, 2)), clean(op(g, 3));
          end;
          userinfo(2,"hypergeometric type is",g);
          if g<>FAIL then
            g:=sum::hypergeomeval(g,op(op(x,2)),clean(f),_k_);
            if g<>FAIL then
              return(g)
            end_if
          end_if;
          if g=FAIL then g:=sum::recognize_gf(f,_k_,op(op(x,2)));
            if g<>FAIL then
              return(clean(g))
            end_if
          end_if;
          userinfo(1,"definite summation of hypergeometrics failed");
        end_if;

        // not hypergeometric in k or in another variable

        f:= FAIL // hold(sum)(f,x)

      else // indefinite summation succeeded
        // try to find undefinite summands in the range of the sum
        sup:= discont(clean(f),x,Undefined) ;
        if domtype(sup) = piecewise then
          if contains({sup[i] $i=1..nops(sup)}, {}) then
            sup:= {} ; // ignore special cases using parameters
          else 
            if traperror(
                   (sup:= _intersect(sup[i] $i=1..nops(sup)) )
                        ) <> 0 then
              sup:= {} ; // To "complicated" try to compute the sum
            end_if:
          end_if:
        end_if:
        
        if domtype(sup) = DOM_SET then
          sup:= select(sup,is,Type::Integer);
        end_if:

        if domtype(sup) = DOM_SET or domtype(sup) = Dom::Interval then
          if sup <> {} then
            error("Singularity");
          end_if:
        end_if:
        
        userinfo(2,"indefinite summation gave",g);
        
        g:= clean(g);
        if traperror(
                     (g:= sum::myeval(g,_k_,op(x,[2,2])+1)
                      - sum::myeval(g,_k_,op(x,[2,1])))
                     )=0 then
          if traperror((f:= normal(g), MaxSteps = 3)) <> 0 or length(f) > length(g) then
            f:= g
          end_if;

        else
          // sum::myeval raises an error iff evaluating 
          error("Singularity");
        end_if:
        
      end_if
    elif type((_p:=op(x,2))) = RootOf then // sum(..., k=RootOf(q,z)) 
      userinfo(1,"sum over RootOf");
      f:= sum::rootOf(_p, _k_, f)
    end_if // type(op(x, 2))
  end_if; // type(x)

  if f = FAIL
    then
    return(hold(sum)(s, x))
  elif type(f) = "sum" then
    // we may return f or the unevaluated original sum,
    // depending on what is simpler
    g:= hold(sum)(s, x);
    if length(f) < length(g) then
      return(f)
    else
      return(g)
    end_if
  else
    return(clean(f))
  end_if;
end_proc:

sum::sum:= prog::remember(sum::sum, property::depends):

/* the following extension was suggested by Daniel Duparc
  <dduparc@club-internet.fr> */
sum::recognize_gf:=proc(f,n,a,b) local s,P,x,Q,lc,d;
begin
   P:=genident("P"); x:=genident("x");
   // recognizes sum(P(n)*x^n/n!, n=0..infinity) 
   if a=0 and b=infinity then
      s:=intlib::match(n!*f, _pattern(P,Type::PolyExpr(n))*_pattern(x)^n);
      if s<>FAIL then
         P:=subs(P,s,EvalChanges); x:=subs(x,s,EvalChanges); Q:=0;
         // x^i*exp(x) -> n*(n-1)*...*(n-i+1) = n!/(n-i)! 
         while P<>0 do
            lc:=lcoeff(P,[n]); d:=degree(P,[n]);
            Q:=Q+lc*x^d; P:=expand(P-lc*n!/(n-d)!);
         end_while;
         return(Q*exp(x));
      end_if
   end_if;
   FAIL
end_proc:

sum::ishypergeom :=
proc(f,n)
begin
  testtype(sum::ratio(f,n),Type::RatExpr(n))
end_proc:

/* f being hypergeometric in k, puts f(k+1)/f(k) in the form
  (k+a1)...(k+ap)/(k+b1)/.../(k+bq) x/(k+1)
  and returns [a1,...,ap], [b1,...,bq], x,
  cf Wilf page 5 */
sum::hypergeomtype :=
proc(f,k)
  local g,P,Q,a,b,x,t,d;
begin
  g:=normal(subs(sum::ratio(f,k),k=k+1));
  P:=Factored::convert_to(factor(numer(g)),DOM_EXPR);
  if type(P)<>"_mult" then
    P:=[P]
  end_if;
  a:=[]; b:=[]; x:=1;
  for t in P do
    if not has(t,k) then
      x:=x*t
    else
      if type(t)="_power" then
        d:=op(t,2);
        t:=op(t,1)
      else
        d:=1
      end_if;
      if degree(t,k)<>1 then
        return(FAIL)
      end_if;
      x:=x*coeff(t,k,1);
      a:=append(a,coeff(t,k,0)/coeff(t,k,1) $ d);
    end_if
  end_for;
  Q:=Factored::convert_to(factor(denom(g)),DOM_EXPR);
  if type(Q)<>"_mult" then
    Q:=[Q]
  end_if;
  for t in Q do
    if not has(t,k) then
      x:=x/t
    else
      if type(t)="_power" then
        d:=op(t,2);
        t:=op(t,1)
      else
        d:=1
      end_if;
      if degree(t,k)<>1 then
        return(FAIL)
      end_if;
      x:=x/coeff(t,k,1);
      b:=append(b,coeff(t,k,0)/coeff(t,k,1) $ d);
    end_if
  end_for;
  t:=contains(b,1);
  if t=0 then // no factor k+1 in the denominator, add one
    a:=append(a,1)
  else // delete it
    delete b[t]
  end_if;
  a,b,x
end_proc:


/****
sum::hypergeomeval(P, Q, z, a, b, f, k)

computes
sum(f,k=a..b) when 
sum(f,k={0,1}..infinity) = pFq(P,Q,z) * f(0)

P = [a1, ..., ai], Q= [b1, ..., bj]
means f(k)/f(k+1) = (k+a1)(k+a2)..(k+ai) / ((k+b1)..(k+bj) * z/(k+1)

where z does not depend on k

****/

sum::hypergeomeval :=
proc(P,Q,z,a,b,f,k)
  local init, kk, pos, n, l, hypergeomshift: DOM_PROC;
begin

  // local method hypergeomshift(c)
  // writes the sum in terms of k+c
  // uses (and changes) P, Q, a, b, f
  // uses k
  //
  // substitute k -> k+c 
  // then z is unchanged, f -> subs(f, k = k+c)
  //      f(k)/f(k+1) -> f(k+c)/f(k+c+1) = ((k+a1+c)..(k+ai+c)) /
  //                      ((k+b1+c) ..(k+bj+c)) * z / (k+c+1)
  // since the last denominator needs to be k+1, we have to add
  // another k+1 in the numerator and a k+c+1 in the denominator.
  // Finally, we have to cancel common elements of numerator and denominator
  // if k ran from a to b, then the new k runs from a-c to b-c
 
  hypergeomshift:=
  proc(c: DOM_INT) //:void, only side effects
    local i;
  begin
    P:= map(P, _plus, c);
    Q:= map(Q, _plus, c);
    if (i:= contains(P, c+1)) > 0 then
      // this will cancel out against c+1 in the denominator
      delete P[i]
    else
      Q:= [c+1].Q
    end_if;
    if (i:= contains(Q, 1)) > 0 then
      delete Q[i]
    else
      P:= [1].P
    end_if;
    f:= subs(f, k = k+c);
    a:= a-c;
    b:= b-c;
    P:= sort(P);
    Q:= sort(Q)
  end_proc;
  
  assert(not has(z, `#E`));

  P:= sort(P);
  Q:= sort(Q);
  
// reduce hypergeomtype by shift if possible:
  // the numerator must contain k+1, and the denominator must contain k+b
  // for some integer b
  if (pos:= contains(P, 1)) > 0 and
    nops((l:= select(Q, testtype, DOM_INT))) >= 1 then
    userinfo(1, "reducing hypergeomtype");
    n:= - min(l) + 1;
    // substituting k by k+n will reduce the hypergeomtype
    hypergeomshift(n);
    userinfo(2, "new hypergeomtype is ".expr2text(P, Q, z));
  end_if;
  userinfo(1,"hypergeometric of type ".nops(P)."F".nops(Q));
  case [nops(P), nops(Q)]
    of [1, 0] do // 1F0
      if testtype(a,Type::NonNegInt) and b=infinity then
        userinfo(2,"1F0 with right bound at infinity");
        if P=[0] then
          // f(1) * sum(z^k/k, k=1..infinity)
          if a = 0 then
            error("Zero denominator in first summand")
          end_if;

          init:=_plus(subs(f,k=kk,EvalChanges) $ kk=1..a-1);
          return(piecewise([abs(z) <= 1 and not z=1,
                            -ln(1-z)*subs(f,k=1,EvalChanges)/z-init  ],
                           [z >= 1, infinity * subs(f, k=1)],
                           [abs(z) > 1 and not z>=1, undefined]))
        else
          if testtype(P[1], Type::NegInt) then
            // e.g., sum((-1)^k/k/(k-1), k = 2..infinity)
            // not really satisfying, but otherwise the call
            // above provokes an error
            return(FAIL)
          end_if;
          init:=_plus(subs(f,k=kk,EvalChanges) $ kk=0..a-1);
          return(((1-z)^(-P[1])-init)*subs(f,k=0,EvalChanges))
        end_if
      end_if;
      break
    of [0, 0] do // 0F0
      // a must be non-negative *after* removing leading zeroes
      while iszero(f | k=a) do
         a:= a+1
      end_while;
      if is(a>b, Goal = TRUE) then
         return(0)
      end_if;
      if testtype(a, Type::NegInt) then
        error("One summand has zero denominator")
      end_if;
      if testtype(a,Type::NonNegInt) and b = infinity then
        init:=eval(_plus(sum::myeval(f,k, kk) $ kk = 0..a-1));
        return(exp(z)*(limit(f,k=0) assuming k in C_) - init)
      end_if;
      break
    of [2, 1] do // 2F1
      if contains(P, 1)>0 and type((kk:= op(Q, 1) - 3/2)) = DOM_INT then
        hypergeomshift(-kk);
        userinfo(2, "shifting gives hypergeomtype ".expr2text(P, Q, z));
        assert([nops(P), nops(Q)] = [2, 1])
      end_if;
      return((if P=[1/2,1] and Q=[3/2] and testtype(a, DOM_INT) and
                b=infinity then
                if a >= 0 then
                  init:= -_plus(subs(f,k=kk,EvalChanges) $ kk=0..a-1)
                else
                  init:= _plus(subs(f,k=kk,EvalChanges) $ kk=a..-1)
                end_if;
                arctan(I*sqrt(z))/I/sqrt(z) * subs(f, k=0, EvalChanges) + init
              elif P=[0,0] and Q=[1] and testtype(a,Type::PosInt) and
                b=infinity then
                init:=_plus(subs(f,k=kk,EvalChanges) $ kk=1..a-1);
                polylog(2,z)*subs(f/z,k=1,EvalChanges)-init
              else
                FAIL
              end_if));
      // NOT REACHED
      assert(FALSE)
     of [3, 2] do // 3F2 
      if P=[1,1,1] and Q=[3/2, 2] and z=1/4 and b=infinity and
        testtype(a,Type::NonNegInt) then // sum(n!^2/(2*n+2)!,n=a..infinity)
        _plus(f $ k=0..a-1);
        return((PI^2/9-2*eval(%))*subs(f,k=0,EvalChanges))
      end_if;
      if P = [1/2, 1/2, 1] and Q = [3/2, 3/2] and z=-1 and b=infinity and
        testtype(a,Type::NonNegInt) then
        init:= _plus(subs(f,k=kk,EvalChanges) $ kk=0..a-1);
        return(CATALAN - init)
      end_if;
  end_case;
  FAIL
end_proc:


// another utility for patterns
sum::sum_fn :=
proc(f, range)
local k, res, err;
begin
  if testtype(range[1], DOM_INT) and testtype(range[2], DOM_INT) then
    _plus(f(k) $ k=range);
  else
    k := solvelib::getIdent(Z_, indets(f, All) union indets(range));
    if (err:=traperror((res := sum(f(k), k=range)), MaxSteps=20)) = 0 and
     not has(res, k) then
      res;
    else
      if err<>1321 and err<>0 then lasterror(); end_if;
      procname(args());
    end_if;
  end;
end:

sum::expand_sum_fn :=
proc(f, range)
  local k;
begin
  if testtype(range[1], DOM_INT) and testtype(range[2], DOM_INT) then
    _plus(f(k) $ k=range);
  else
    k := solvelib::getIdent(Z_, indets(f, All) union indets(range));
    sum(f(k), k=range);
  end_if;
end_proc:

//-------------------------------------
// utility for
// sum(f(k)*kroneckerDelta(k,k0), k = 0..infinity) = subs(f(k), k = k0)
//-------------------------------------
sum::evalAtPoint:= (f, k, k0) -> subs(f, k = k0, EvalChanges):

// definite sums involving kroneckerDelta
sum::kroneckerDeltaDefinite :=
proc(s, x)
  local delta, k, a, b, zeroes, allzeroes;
begin
  k := op(x, 1);
  [a, b] := [op(op(x, 2))];
  delta := misc::subExpressions(s, "kroneckerDelta");
  if nops(delta)=0 then
    error("internal logic error");
  end_if;
  delta := op(delta, 1);
  zeroes := solve(op(delta, 1)=op(delta, 2), k=a..b) intersect Z_;
  if hastype(zeroes, "solve") then
    return(hold(sum)(s, x));
  end_if;
  if domtype(zeroes) = piecewise then
    allzeroes := _union(op(piecewise::expressions(zeroes)));
  else
    allzeroes := zeroes;
  end_if;
  piecewise::extmap(zeroes, S -> sum(subs(s, delta=1), k in S)) +
  sum(subs(s, delta=0), k in (Dom::Interval([a, b]) intersect (Z_ minus allzeroes)));
end_proc: