// u is the name of the output recurrence
//
// Literature:
//   Concrete mathematics 2ed.; Graham, Knuth, Patashnik
//   Hypergeometric Summation; Wolfram Koepf          
//
sum::zeilberger:=
proc(f,_k,n,u,a,b, options) // sum(f,k=a..b) 
local ratn,d,l,m,C,p,ratk,res,rnk,cert,va,vb,A,corr,i,sup,aa,bb;
  
begin
   if has(a,n) then return(FAIL) end_if; // not yet treated 

   ratn:=sum::ratio(f,n); // f(n)/f(n-1) 
   if not has(ratn,{n,_k}) then 
	return(FAIL) 
   elif not testtype(ratn,Type::RatExpr(n)) then 
	return(FAIL)
   elif not testtype(ratn,Type::RatExpr(_k)) then 
	return(FAIL)
   end_if;

   d:=1;
   C:= genident("CC");
   repeat
      rnk:=1; m:=1;
      for l from 1 to d do
         m:=m*subs(ratn,n=n+l); // now m=f(n+l)/f(n) 
         rnk:=rnk+C[l]*m;
      end_for;
      // now apply Gosper to rnk*f with respect to k 
      /* i.e. search if F=f(n)+C[1]*f(n+1)+...+C[d]*f(n+d)
        satisfies F(k)=G(k+1)-G(k) */
      userinfo(3,"rnk=",rnk);
      l:=C[l]$ l=1..d;
      p:=numer(rnk);
      ratk:=sum::ratio(f/denom(rnk),_k);
      res:=sum::gosper2(p,numer(ratk),denom(ratk),_k,{l},rnk*f);
      if res = "timeout" then
        return(FAIL)
      end_if;
      if res<>FAIL then
        // according to Koepf the rational certificate R is R=G/F
        // which is the result of the gosper algorithm
        userinfo(1,"certificate=",subs(res[1],res[2]));
        cert:=subs(res[1]*rnk,res[2],EvalChanges); // g = cert*f
        if a = -infinity and b = infinity then
          A:=_plus(u(n),C[l]*u(n+l)$ l=1..d) ;
        else
          /* one should have subs(G,k=k+1)-G-F=0 where
             F=f(n)+C[1]*f(n+1)+...=rnk*f and G=(cert/rnk)*F=cert*f,
             i.e. subs(cert*f,k=k+1)/f-cert-rnk=0 */
          /* thus sum(f,k=a..b)+...+sum(subs(f,n=n+d),k=a..b)
                = subs(f*cert,k=b+1) - subs(f*cert,k=a) */
          /* only deal with the cases where a is independent from n
             and b is independent from n or b=n */
          sup:=sum::support(f,_k);
          // if a<=op(sup,1) we can extend the lower bound to -infinity
          aa:=simplify(min(a,op(sup,1)));
          va := sum::myeval(f*cert, _k, a);
          // if op(sup,2)<=b we can extend the upper bound to infinity
          bb:=simplify(max(b,subs(op(sup,2),n=n+d)));
          // We have:
          // G = cert*f and
          // F = rnk*f = subs(G,k=k+1) - G <=> F - subs(G,k=k+1) + G = 0
          // So we have:
          // sum(F,k=a..b) = G(n.k+1) - G(n,k) = G(n,b+1) - G(n,a)
          vb := sum::myeval(f*cert, _k, b + 1);
          A:=_plus(u(n),C[l]*u(n+l)$ l=1..d);
          A:=A+eval(va-vb);
          if A=undefined then return(FAIL)
            // correcting terms if b depends on n
            // Because we have:
            // sum(F(n,k),k=a..b) + C_1*sum(F(n+1,k),k=a..b) + ..... +
            // C_d*sum(F(n+d,k),k=a..b) = G(n,b+1) - G(n,a)
            // It follows with s_n:= sum(F(n,k),k=a..b)
            // Attention: s_(n+d) = subs(sum(F(n,k),k=a..b),n=n+d) =
            //                    = sum(F(n+d,k),subs(k=a..b,n=n+d))
            // E.g. if b = n and a does not contain n we have:
            //   s_(n+d) = sum(F(n+d,k),k=a..b+d) =
            //           = sum(F(n+d,k),k=a..b) + sum(F(n+d,k),k=b+1..b+d)
            //           = sum(F(n+d,k),k=a..n) + sum(F(n+d,k),k=n+1..n+d)
            // So we have:
            // s_n + C_1*s_(n+1) + ..... + C_d*s_(n+d) =
            // sum(F(n,k),k=a..b) + C_1*sum(F(n+1,k),subs(k=a..b,n=n+1)) +
            //                    + C_d*sum(F(n+d,k),subs(k=a..b,n=n+d)) =
            // sum(F(n,k),k=a..b) + C_1*sum(F(n+1,k),k=a..b) +
            //                    + C_d*sum(F(n+d,k),k=a..b) -
            //            - sum(sum(C_l*F(n+l,k),k=b+1..subs(b,n=n+l)),l=1..d)
            // corr:=  sum(sum(C_l*F(n+l,k),k=b+1..subs(b,n=n+l)),l=1..d)
            // is computed below
            // Remember (see above in this implementation), at the moment
            // the case that a contains n is not treated!
          elif bb<>b and not has(b-n,n) then
            if traperror
            ((
              corr:=_plus((C[l]*subs(f,n=n+l,_k=b+i,EvalChanges)$ i=1..l) $ l=1..d) ;
            )) <> 0 then
              return(FAIL)
            end_if;
            A:=A-corr ;
            ;
          else
            return(FAIL)
          end_if;
        end_if:
        A:=expand(subs(A,res[2],EvalChanges));
        /* to check: subs(rnk,res[2])-subs(cert*sum::ratio(f,k),k=k+1)+cert
	        should be zero */
        userinfo(1,"recurrence=",A);
        res:=numer(A);
        res:=-coeff(res,u(n+d),0)/coeff(res,u(n+d),1);
        res:=u(n+d)=collect(res,[u(n+l)$ l=0..d-1],
                            x->Factored::convert_to(factor(x),DOM_EXPR));
        if iszero(subs(denom(cert),n=0,EvalChanges)) then d:=d+1 end_if;
        if hastype(res, "fact") then
          res:=rewrite(res, gamma)
        end_if;
        res:= misc::maprec(res, {"gamma"} = expand);
        return([res,d])
      else
        userinfo(1,"Gosper's algorithm fails for order ",d);
      end_if;
     d:= d+1; // try a higher order
   until d > options[hold(MaxOrder)] end_repeat;
  FAIL
end_proc:

