
alias(IntTrans = transform::IntTrans);

exp:=slot(exp,"transform::fourier",
  proc(_f, var1, var2) 
    local ana, _a, _c;
  begin

    _a:=op(_f)/abs(var1);
    if not has(_a, var1) then
      if is(_a<0) then
        _a:=-_a;
        userinfo(3, "formula 8 from Foellinger");
        return( 2*_a/(_a^2+var2^2)  ); 
      end_if;
    end_if;

    _a:=op(_f)/var1^2;
    if not has(_a, var1) then
      if is(_a<0) then
        _a:=-_a;
        userinfo(3, "formula 10 from Foellinger");
        return( sqrt(PI/_a)*exp(-var2^2/4/_a^2)  ); 
      end_if;    
    end_if;

   _a:=op(_f)/var1;
   if not has(_a, var1) then
     if not has(_a/I, I) then
       userinfo(3, "formula 14 form Foellinger"  );
       return( 2*PI*dirac(var2-_a/I));
     end_if;   
   end_if;

   return(FAIL);
  end_proc):

unalias(IntTrans):

// end of file 

