// Dirk Mueller, olorien, 28/10/96, v1.0 

alias( IntTrans = transform::IntTrans ):

_mult:=slot(_mult, "transform::fourier", 
proc(_fu, var1, var2) 
    local ana, L, rat, nonrat, nonrat_types, m, i, match_set, match_list, 
         _g, test, trafo, _c, pos, L2, the_end, _n,
         Num, Den, _lin, Num_sp, Den_sp, Den_L, Den_code, Num_code,
         rat_code, nonrat_code, rat_pat, nonrat_pat,
         _a;
begin

  Num:=numer(_fu); Den:=denom(_fu);
    if type(Num)="_mult" then
      _lin:=select(Num, not has, var1);
      Num:=Num/_lin;
    elif not has(Num, var1) then
      _lin:=Num; Num:=1;
    else
      _lin:=1;
    end_if;

  Num_sp:=[IntTrans::mult_split(Num, var1)];
  Den_sp:=[IntTrans::mult_split(Den, var1)];

  if Num_sp[1]=1 and Den_sp[2]=1 then // NonRat / Rat 
    if Den=var1 then
       Num_code:=IntTrans::nonrat_ana(Num, var1);
       Num_pat:=[Num_code[1], Num_code[2], Num_code[3]];
       if Num_pat=[ "_mult", ["sin"], [1] ] then
         this_op:=Num_code[4][1];
         _a:=this_op/var1;
         if not has(_a, var1) then
           userinfo(3, "formula 2 form Foellinger");
           return( -PI*heaviside(var2-_a)+PI*heaviside(var2+_a)   );
         end_if;
       end_if;

    elif Den=1 then // NonRat / 1 
      Num_code:=IntTrans::nonrat_ana(Num, var1);
      Num_pat:=[Num_code[1], Num_code[2], Num_code[3]];
      if Num_pat=["_mult", ["sign", "exp"], [1,1]] then
        _b:=Num_code[4][1]; _a:=Num_code[4][2]/abs(var1);

        if _b=var1 and not has(_a, var1) then
          if is(_a>0) then
            userinfo(3, "formula 8 from Foellinger");
            return(  -I*2*var2/(_a^2+var2^2)  );
          end_if;
        end_if;
      end_if;
    end_if;

  elif Num_sp[2]=1 and Den_sp[2]=1 then // Rat / Rat 
    Num_code:=IntTrans::anapol( Num, var1);
    Den_code:=IntTrans::anapol( Den, var1);

    case [Den_code[1][1][2], Den_code[1][2][2], Num_code[1][1][2]]
    of [5, 3, 3] do
      if Den_code[1][1][1]=1 then
        _n:=Den_code[1][2][1];
        if _n=Num_code[1][1][1] then
          if Num_code[2]=[[I,-1]] then
            if Den_code[2]=[[1,0,1],[I,1]] then
              userinfo(3, "formula 3.2.(1) from EMO");
              return(  heaviside(var2)*(-1)^(_n-1)*2*PI*exp(-var2)*
                           exp(2*var2)/var2/2/_n!*diff(exp(-2*var2)*var2^(_n+1),
                               var2 $ i=1.._n)   );
            end_if;
          end_if;
        end_if;
      end_if;
    end_case: // [Den_code[1][1][2], Den_code[1][2][2]] 

  end_if;





  ana:=[IntTrans::mult_split(_fu, var1)];

  rat:=ana[1]; nonrat:=ana[2]; 
  match_list:=["exp", "cos", "sin"];

  test:=IntTrans::anapol(rat, var1);
 
  if test[1][1][2]=2 then

    _n:=test[3][1][1];
    if is(_n>0)=TRUE then
      trafo:=(transform::laplace)(nonrat, var1, var2);
      userinfo(3, "power modulation");
      return( (-1)^_n*diff(trafo, var2 $ k=1.._n) );
/*
    elif is(_n<0) then
      return(FAIL);
*/
    end_if;
  end_if;

  if type(nonrat)<>"_mult" then
    nonrat_types:=[type(nonrat)];
  else
    nonrat_types:=[map(op(nonrat), type)];
  end_if;

  m:=nops(nonrat_types);

  for i from 1 to nops(match_list) do
    pos:=0: 
    L2:=[ (pos:=contains(nonrat_types, match_list[i], pos+1)) 
                $ k=1..nops(nonrat_types),0  ];

    the_end:=contains(L2, 0);

    for j from 1 to the_end-1 do
     if type(nonrat)="_mult" then
       test:=op(op(nonrat, L2[j]));
     else
       test:=op(nonrat);
     end_if;

      if testtype(test, Type::RatExpr(var1)) then
        ana_args:=IntTrans::anapol(test, var1);
        _c:=ana_args[2][1][2];

        if m=1 then
          _g:=rat;
        else
          _g:=subsop(nonrat, L2[j]=1)*rat;
        end_if;

        if ana_args[1][1]=[1,2] then

          case nonrat_types[L2[j]] 
          of "exp" do
            _c:=_c/I;
            if not has (_c, I) then
              if is(_c>0)=TRUE then
                userinfo(3, "exp-modulation");
                return((transform::fourier)(_g, var1, var2-_c));
              end_if;
            end_if;
            break;

          of "sin" do 
            trafo:=(transform::fourier)(_g, var1, var2); 
            userinfo(3, "sin-modulation");
            return( 1/2/I*(subsex(trafo, var2=var2-_c)-
                             subsex(trafo, var2=var2+_c)));
           
            break;

          of "cos" do
           
            trafo:=(transform::fourier)(_g, var1, var2);
            userinfo(3, "cos-modulation");
            return( 1/2*(subsex(trafo, var2=var2-_c)+
                         subsex(trafo, var2=var2+_c)));
            break;
          end_case;
        end_if;
      end_if;
    end_for;
  end_for;

  return(FAIL);

end_proc):

unalias( IntTrans ):

// end of file 
