// Dirk Mueller, olorien, 28/10/96, v1.0 

alias( IntTrans = transform::IntTrans ):


_power:=slot(_power,"transform::fourier",
  proc(_fu, var1, var2) 
    local Den, _n, _f, _a, erg;
  begin

    _f:=op(_fu,1); _n:=op(_fu, 2);
    if _f=var1 then
      erg:=is(_n>-1);
      if erg=TRUE then
        userinfo(3, "formula 53 from Heuser");
        return(gamma(_n+1)/var2^(_n+1));
      elif erg=UNKNOWN then
        userinfo(1, "please specify constant");
      end_if;
      return(FAIL);
    end_if;

    case type(_f)
      of "sin" do
        _a:=op(_f)/var1;
        if not has(_a, var1) then
          if testtype(_n, Type::PosInt) then
            if type(_n/2)=DOM_INT then
              _n:=_n/2;
              userinfo(3, "formula 5.9 from R&K");
              return( (2*_n)!*_a^(2*_n)/ 
                (var2*_mult(var2^2+(2*i)^2*_a^2 $ i=1.._n)) );
              //sin(a*t)^(2*n)
            else
              _n:=(_n-1)/2;
              userinfo(3, "formula 5.10 from R&K");
              return( (2*_n+1)!*_a^(2*_n+1)/ 
                _mult(var2^2+(2*i+1)^2*_a^2 $ i=0.._n) );
              //sin(a*t)^(2*n+1)
            end_if;
          end_if;
        end_if;
        return(FAIL);

      of "cos" do
        _a:=op(_f)/var1;
        if not has(_a, var1) then
          if testtype(_n, Type::PosInt) then
            if type(_n/2)=DOM_INT then
              _n:=_n/2;
              userinfo(3, "formula 5.28 from R&K");
              return( expand( (2*_n)!*_a^(2*_n)*
                      (1+_plus( _mult(var2^2+4*(j*_a-_a)^2 $ j=1..i)/
                        ((2*i)!*_a^(2*i))
                                     $ i=1.._n)
                       ))/
                       (var2*_mult( var2^2+(2*i*_a)^2 $ i=1.._n))
                    );
            else
              _n:=(_n-1)/2;
              userinfo(3, "formula 5.29 from R&K"); 
              return(expand( (2*_n+1)!*_a^(2*_n)*var2*
                      ( 1+_plus( 
                        _mult( var2^2+(2*j*_a-_a)^2 $ j=1..i)/
                            ((2*i+1)!*_a^(2*i))
                                      $ i=1.._n)
                    
                      ))/_mult( var2^2+(2*i*_a+_a)^2 $ i=0.._n)
                    );
            end_if;
          end_if; 
        end_if;
        return(FAIL);

      of "sinh" do
        _a:=op(_f)/var1;
        if not has(_a, var1) then
          if testtype(_n, Type::PosInt) then
            if type(_n/2)=DOM_INT then
              _n:=_n/2;
              userinfo(3, "formula 7.4 from R&K");
              return( (2*_n)!*_a^(2*_n)/ 
                      (var2*_mult( var2^2-i^2*(2*_a)^2 $ i=1.._n)) );
              //sinh(a*t)^(2*n)
            else
              _n:=(_n-1)/2;
              userinfo(3, "formula 7.5 from R&K");
              return( (2*_n+1)!*_a^(2*_n+1)/ 
                _mult(var2^2-(2*i+1)^2*_a^2  $ i=0.._n) );
                //sinh(a*t)^(2*n+1)
            end_if;
          end_if;
        end_if;
        return(FAIL);

    
    end_case;

    
  FAIL;
  end_proc):

unalias( IntTrans ):

// end of file 

