alias( IntTrans = transform::IntTrans ):
alias( invfourier = transform::invfourier ):

invfourier:=newDomain("transform::invfourier"):
invfourier::create_dom:=hold(transform::invfourier):
invfourier::type:="transform::invfourier":

invfourier::has:=proc() local T, v;
begin
  T:=args(1); v:=args(2);
  bool( v=extop(T,2) or v=extop(T,3) or 
        has(extop(T,1), v) or v=hold(invfourier)
  )
end_proc:

invfourier::new:=proc(_f, var1, var2) 
  local _f2, back, mycollect;
begin
  if testargs() then
    if args(0)<>3 then error("wrong number of arguments") end_if;
    if domtype(_f)<>DOM_EXPR and 
       domtype(_f)<>DOM_IDENT and 
       not testtype(_f,Type::Numeric) and 
       type(_f)<>"transform::fourier" then
      error("first argument of wrong type");
    end_if;
    if domtype(var1)<>DOM_IDENT then
      error("second and third argument must be from the type DOM_IDENT");
    end_if;
  end_if;
  if type(_f)="transform::fourier" then
    return(subs(extop(_f,1), extop(_f,2)=var2))
  end_if;
  back:=invfourier::compute(_f, var1, var2);
  if back=FAIL and testtype(_f,Type::RatExpr(var1)) then
     // Walter: 5.4.08 (reaction to changes in partfrac):
     // partfrac((x^2 + a*x + b)/(x^2 + c*x + d), x) produces
     // 1 + (b - d + a*x - c*x)/(x^2 + c*x + d). The matcher
     // has patterns for (A*x + B)/(x^2 + C*x + D), but does 
     // not match a*x-c*x to A*x. We need to collect terms!
     mycollect:= proc(a)
                 begin
                   if not has(a, var1) then
                      return(a)
                   end_if:
                   if type(a) = "_power" and 
                      not has(op(a, 2), var1) then
                      return(mycollect(op(a, 1))^op(a, 2));
                   elif type(a) = "_mult" then
                      // do not loose factorizations, so map
                      // into the factors instead of collecting
                      // the terms of the polynomial
                      return(map(a, mycollect));
                   elif type(a) = "_plus" then
                      return(eval(collect(a, [var1])));
                   end_if:
                   return(a);
                 end_proc:
     back:=invfourier::compute(partfrac(_f, var1, Mapcoeffs = mycollect), var1, var2);
  end_if;
  if back=FAIL then
    _f2:=expand(_f);
    if (not (_f=_f2)) then
      back:=invfourier::compute(_f2, var1, var2);
    end_if;
  end_if;
  if back=FAIL then
    return(new(invfourier, _f, var1, var2)) else return(back)
  end_if;
end_proc:


invfourier::print:=proc(T)
begin
  hold(invfourier)(extop(T,1), extop(T,2), extop(T,3))
end_proc:


//this part computes the inverse exponential fourier transform
invfourier::compute:=proc(_g, var1, var2) local _f, back, typ;
begin
  _f:=_g;
  if not has(_f, var1) then
    return(_f*dirac(var2)); // maple 
  elif _f=var1 then
    return(dirac(1, var2)); // maple ??
  end_if;

  typ:=type(_f);

  if typ="_equal" then
    return(_equal(invfourier(op(_f,1), var1, var2), invfourier(op(_f,2), var1, var2)))
  end_if;


  if typ="_mult" or typ="_plus" then
    back:=IntTrans::linear(new(invfourier, _f, var1, var2));
    if not (back=FAIL) then
      return(back);
    end_if;
  end_if;

  if typ="function" and type(op(_f,0))="D" then
    _f:=IntTrans::D2diff(_f)
  end_if;

  back:=IntTrans::builtin(new(invfourier, _f, var1, var2));
  if not (back=FAIL) then
    return(back);
  end_if;

 return(FAIL);
end_proc:

unalias( invfourier ):
unalias( IntTrans ):

// end of file 
