/*++
v1.0, 28.10.1996, Dirk Mueller (olorien)

   IntTrans -- a library for doing integral transformation
++*/

alias( IntTrans = transform::IntTrans ):

IntTrans:= newDomain("transform::IntTrans"):
IntTrans::create_dom:=hold(transform::IntTrans):
IntTrans::info:= "transform::IntTrans  -- a library for integral transformations":
IntTrans::FREEVARIABLE:=TRUE:

IntTrans::c1:=new(IntTrans, "c1", TRUE, TRUE):
IntTrans::c2:=new(IntTrans, "c2", TRUE, TRUE):
IntTrans::c3:=new(IntTrans, "c3", TRUE, TRUE):
IntTrans::c4:=new(IntTrans, "c4", TRUE, TRUE):
IntTrans::c5:=new(IntTrans, "c5", TRUE, TRUE):
IntTrans::c6:=new(IntTrans, "c6", TRUE, TRUE):
IntTrans::c7:=new(IntTrans, "c7", TRUE, TRUE):
IntTrans::c8:=new(IntTrans, "c8", TRUE, TRUE):

IntTrans::mult_split:=proc(_f, var)

// ---------------- introduction by Stephan Huckemann, 9, 2002 -------
// decomposes _f into a product of
//	_rat = polynomial in t where t appears with powers constant in t
//		(so it's not too rational in the usual sense)
//	_nonrat = _f/_rat
// and returns [_rat, _nonrat]
// S.H. 9/2002 Bugfix
// 	It used to be:
//		_rat = a real power of a rational function in var
//		but not quite consistently:
//		 	    mult_split(t^a, 1) = [1, t^a]
//      		but mult_split(t*t^a,1) = [t*t^a,1]
// 		and even graver:
//      		    but mult_split(t*t^t,1) = [t*t^t,1]
// 
// -----------------------------------------------------------------------

local _rat, _nonrat, _g, _h, P_list, _p, _paus, i, typ, P_list1;
begin

  typ:=type(_f);
  if typ<>"_mult" then 
    if testtype(_f, Type::RatExpr(var)) then
      return(_f,1);
    else
      if typ="_power" then
//        if testtype(op(_f, 2), Type::Real) and
//	----- S.H. guesses that is a kind of a fix 9/2002
        if not has (op(_f, 2), var) and
           testtype(op(_f, 1), Type::RatExpr(var)) then
          return(_f, 1);
        else
          return(1, _f);
        end_if;
      else
        return(1,_f);
      end_if;
    end_if;
  end_if;

  _rat:=select(_f, testtype, Type::RatExpr(var));

  _nonrat:=normal(_f/_rat); 

  if _nonrat<>1 then
    if type(_nonrat)<>"_power" then
      _g:=select(_nonrat, testtype, "_power");
    else
      _g:=_nonrat;
    end_if;

    if _g<>1 and _g<>0 then
      if type(_g)="_power" then
//      P_list:=[testtype(op(_g,1), Type::RatExpr(var))];
//	----- S.H. guesses that is a kind of a fix 9/2002
        P_list:=[testtype(op(_g,1), Type::RatExpr(var)) and not has (op(_g, 2), var)];
        if P_list[1] then
          _rat:=_rat*_g;
          _nonrat:=normal(_nonrat/_g);
        end_if;
      else
	// select(_nonrat, testtype, "_power") oben liefert
	// beim Argument exp(a) exp() zurueck.  Das wuerde in 
	// map unten in einen Fehler laufen, dies fangen wir nun ab.
	// (tonner  25.01.2000)
 	if nops(_g) = 0 then
//	----- S.H. "similar" fix 9/2002
	  P_list  := [1];
	  P_list1 := [1];
	else
          P_list :=[map(op(_g), op, 1)];
          P_list1:=[map(op(_g), op, 2)];
	end_if;

        P_list:=map(P_list, testtype, Type::RatExpr(var));
        P_list1:=map(P_list1, not has, var);
        P_list:=zip(P_list, P_list1, _and);

        _p:=[contains(P_list, TRUE, i) $ i=1..nops(P_list)];
        _paus:=nops({op(_p)});
        if _p[1]<>0 then
          _h:=_mult(op(_g, _p[i]) $ i=1.._paus);
          _rat:=_rat*_h;
          _nonrat:=normal(_nonrat/_h);
        end_if;
      end_if;
    end_if;
  end_if;

  return(_rat, _nonrat);
end_proc:


IntTrans::nonrat_ana
:=proc(_fu, var, depth)

// ---------------- introduction by Stephan Huckemann, April, 2002 -------
//  returns a list with 5 entries
//		PLUS_MULT, TYPES, EXPOS, VARIABLES, CONSTANTS
//
//  The function _fu is decomposed into factors and summands _f_1,...,_f_n each
//  to a power expo_1,...,expo_n. Moreover multiplicative constants _c_1, ..., _c_n
//  are taken from the _f_1, ..., _f_n (at least = 1)
//
//  PLUS_MULT = _plus if type(_fu) = _plus
//            = _mult otherwise
//
//  TYPES     = type(_f_1) if n = 1
//            = [typ(_f_1), ..., typ(_f_n)] else
//
//  EXPOS     = exp_1 if n = 1
//            = [exp_1, ...., exp_n] else
//
//  VARIABLES = op(op(_f_1,1) if n = 1
//            = [op(op(_f_1,1), ..., op(op(_f_n,1)] else
//                  (e.g. op(sin(3+x),1) = 3 + x)
//
//  CONSTANTS = [_c_1] if n = 1
//            = [_c_1, ..., _c_n]
//
//  Problems:
//	1) If an exponent is non-trivial and the corresponding _f_k consists of more
//  than one operand, e.g. (sin(x)*exp(x))^PI, then _f_k is ignored and taken
//  from the list [_f_1,..., _f_n] ....
//
//	2) This procedures does not seem to be devised to see
//  too many rational components: some simple combinations with rationals 
//  _fu = sin(x)+b*x   ->   FAIL
//
//	3) Use of [DOM_IDENT] and ["RAT"] does not seem to bee consistent
//  TYPES of _fu = sin(x)+x are ["RAT", "sin"]
//		whereas
//  TYPES of _fu = x        is  [DOM_IDENT]
//  ------------------ changes by S.H. Sept 2002 ------------------------
//  No longer [DOM_IDENT], [DOM_INT], [DOM_FLOAT] are returned, just ["RAT"]
//	I think that is what we want
//  Moreover the list are sorted according to types
// -----------------------------------------------------------------------

local _f, typ, types, expos, funcops, consts, const, i,
          this_op, rat_part, nonrat_part, op_typ, back;
begin
  _f:=_fu;
  if has(_f, exp) then 
    _f:=combine(_f, exp);
  end_if;

  typ:=type(_f);
  back:=[];
  expos:=[];
  funcops:=[];
  types:=[];
  consts:=[];

  case typ
  of "_mult" do

    const:=select(_f, not has, var);
    _f:=normal(_f/const);

    if type(_f)<>"_mult" then
      if type(_f)="_power" then
        if nops(op(_f,1))=1 then
//------------- S.H. Sept. 2002 ------------------------------
		if testtype(_f, Type::RatExpr(var)) then
        	  return(["_mult", ["RAT"], [op(_f,2)], [op(op(_f,1))], [const]]); 
		end_if;
//------------------------------------------------------------
          return(["_mult", [type(op(_f,1))], [op(_f,2)], [op(op(_f,1))], [const]]); 
        end_if;
        return(FAIL);
      end_if;
      

      if nops(_f)=1 then
//------------- S.H. Sept. 2002 ------------------------------
		if testtype(_f, Type::RatExpr(var)) then
        	  return(["_mult", ["RAT"], [1], [op(_f)], [const]]); 
		end_if;
//------------------------------------------------------------

        return(["_mult", [type(_f)], [1], [op(_f)], [const]]); 
      end_if;
      return(FAIL);
    end_if;

    for i from 1 to nops(_f) do    // now _f is a product

      this_op:=op(_f, i); op_typ:=type(this_op);
     case op_typ


      of "_power" do
         if nops(op(this_op,1))=1 then
//------------- S.H. Sept. 2002 ------------------------------
		if testtype(op(this_op,1), Type::RatExpr(var)) then
	           types:=types.["RAT"];
		else
        	   types:=types.[type(op(this_op,1))];
		end_if;
//------------------------------------------------------------
//         types:=types.[type(op(this_op,1))];
           expos:=expos.[op(this_op,2)];
           funcops:=funcops.[op(op(this_op,1))];
	   consts:=consts.[1]; 		// S.H, Sept. 2002, we want to have
					// some constants after all
					// I don't think they are used yet
					// if used later on, work on assignment
         end_if;
         break;

      otherwise 
        if nops(this_op)=1 then
//------------- S.H. Sept. 2002 ------------------------------
		if testtype(this_op, Type::RatExpr(var)) then
	           types:=types.["RAT"];
		else
        	   types:=types.[type(this_op)];
		end_if;
//------------------------------------------------------------
//          types:=types.[type(this_op)];
          expos:=expos.[1];
          funcops:=funcops.[op(this_op)];
          consts:=consts.[const];	// S.H. Sept 2002
					// I don't think they are used yet
					// if used later on, work on assignment

        end_if; 
      end_case; // op_typ 
    end_for;
    return(["_mult", IntTrans::sort_n(types, expos, funcops, consts)]);

  of "_plus" do
    for i from 1 to nops(_f) do
      this_op:=op(_f, i); op_typ:=type(this_op);
      case op_typ
      of "_mult" do
        rat_part:=select(this_op, testtype, Type::RatExpr(var));
        nonrat_part:=normal(this_op/rat_part);
        if not has(rat_part, var) then
          case type(nonrat_part)
          of "_power" do 
            if nops(op(nonrat_part,1))=1 then
//------------- S.H. Sept. 2002 ------------------------------
		if not has(op(nonrat_part,1), var) then
	           types:=types.["RAT"];
		else
	           types:=types.[type(op(nonrat_part,1))];
		end_if;
//------------------------------------------------------------
//              types:=types.[type(op(nonrat_part,1))];
              expos:=expos.[op(nonrat_part,2)];
              funcops:=funcops.[op(op(nonrat_part,1))];
              consts:=consts.[rat_part];

            end_if;

            break;

          of "_mult" do
            return(FAIL);

          otherwise
//------------- S.H. Sept. 2002 ------------------------------
		if not has(nonrat_part, var) then
	           types:=types.["RAT"];
		else
	           types:=types.[type(nonrat_part)];
		end_if;
//------------------------------------------------------------
//            types:=types.[type(nonrat_part)];
            expos:=expos.[1];
            funcops:=funcops.[ op(nonrat_part)];
            consts:=consts.[rat_part];

          end_case; // type(nonrat_part) 
        else
          return(FAIL);
        end_if;
        break;

      of "_power" do
         if nops(op(this_op,1))=1 then
//------------- S.H. Sept. 2002 ------------------------------
		if testtype(op(this_op,1), Type::RatExpr(var)) then
	           types:=types.["RAT"];
		else
        	   types:=types.[type(op(this_op,1))];
		end_if;
//------------------------------------------------------------
//           types:=types.[ type(op(this_op,1))];
           expos:=expos.[op(this_op,2)];
           funcops:=funcops.[op(op(this_op,1))];
           consts:=consts.[1];

         end_if;
         break;

      otherwise

        if testtype(this_op, Type::RatExpr(var) ) then
		// S.H. Sep. 2002 actually we only get here 
		// if this_op is a constant
          types:=types.["RAT"];
          expos:=expos.[1];
// S.H.         consts:=consts.[1];
// S.H.         funcops:=funcops.[this_op];
          funcops:=funcops.[1];
          consts:=consts.[this_op];
        else

          if nops(this_op)=1 then
//------------- S.H. Sept. 2002 ------------------------------
		if testtype(this_op, Type::RatExpr(var)) then
	           types:=types.["RAT"];
		else
        	   types:=types.[type(this_op)];
		end_if;
//------------------------------------------------------------
//            types:=types.[type(this_op)];
            expos:=expos.[1];
            funcops:=funcops.[op(this_op)];
            consts:=consts.[1];
          end_if;
        end_if; 
      end_case; // op_typ 
      end_for;
      return(["_plus", IntTrans::sort_n(types, expos, funcops, consts)]);

  of "_power" do
    if nops(op(_f,1))=1 then
//------------- S.H. Sept. 2002 ------------------------------
		if testtype(_f, Type::RatExpr(var)) then
        	  return(["_mult", ["RAT"], [op(_f,2)], [op(op(_f,1))], [1]]); 
		end_if;
//------------------------------------------------------------
      return(["_mult", [type(op(_f,1))], [op(_f,2)], [op(op(_f, 1))], [1]]);
    end_if;

  otherwise
    if nops(_f)=1 then
//------------- S.H. Sept. 2002 ------------------------------
		if testtype(_f, Type::RatExpr(var)) then
        	  return(["_mult", ["RAT"], [1], [op(_f)], [1]]); 
		end_if;
//------------------------------------------------------------
      return(["_mult", [type(_f)], [1], [op(_f)], [1]]);
    end_if;
  end_case; // typ 
//------------ S.H. Sept. 2003 -------------------------------
	return(FAIL);		// otherwise NIL might be returned 
//------------------------------------------------------------
end_proc:


IntTrans::anamult:=proc(_f, _var)
local _L, code, OPS, i;
begin
  _L:=[]; OPS:=[]; code:=[];
  for i from 1 to nops(_f) do 
    if nops(op(_f, i))=1 then
      _L:=IntTrans::anapol(op(op(_f, i)), _var);
      if _L=FAIL then
        return(FAIL);
      end_if;
    else
      _L:=IntTrans::anapol(op(_f, i), _var);
      if _L=FAIL then
        return(FAIL);
      end_if;
    end_if;
    code:=code._L[1];
    OPS:=OPS._L[2];
  end_for;
  return(code, OPS);
end_proc:


IntTrans::anapol:=proc(_f, _var)

// ---------------- introduction by Stephan Huckemann, April, 2002 -------
// returns three lists:
//	code, coefficients and expos
// it's the list 
//                [[[0,0]], [[0,0]], [[0]]]
// unless the following prevail:
//
// if _f is a polynomial in _var, then
//	the first list is a list 
//        [code(_f)]
//      with entry
//	code(_f) = [1, a number in a "binary" format telling which coefficients are non-zero]
//	the second list is a list 
//        [coeff(_f)]
//      with entry
//	coeff(_f)= the list of the coefficients in ascending order
//	the third list is a list 
//        [expos(_f)]
//      of entry
//	expos(_f) = [1]
//
// if _f is the power expo of a polynomial _g in _var then
//	the first list is the list with entry
//	  code(_f) = [expo, a number in a "binary" format telling which coeff. of _g are non-zero]
//		note: expo = 0 if the xponent is non-numeric
//	the second list is the list with entry
//	  coeff(_f) = coeff(_g)
//	the third list is the list of entry
//	  expos(_f) = [expo]
//
// if _f is a product of two polynomials _f1 and _f2 each in _var, then
//	the first list is
//	  code(_f) = [code(_f2), code(_f1)]
//	the second list is
//	  coeff(_f) = [coeff(_f2), coeff(_f1)]
//	the third list
//	  expos(_f) = [expos(_f2), expos(_f1)]
//
// and likewise for products with more than two factors
//
// exceptions:
// 	if _f is a  power expo of var then as guessed
//        [[[expo, 2]], [[0, 1]], [[expo]]]
//	is returned for expo = numeric. If, however,
//	expo is sympolic then
//        [[[0, 2]], [[0, 1]], [[p]]]
// 	is returned.
//
// Note that
//	_f = (x - 1) * (x + 1) and _f = x^2 - 1
//	result in different lists
// -----------------------------------------------------------------------

local i, j, _g, _coeff, Deg, expo, expos, code, OPS;
begin
  code:=[]; OPS:=[]; expos:=[];

  if type(_f)="_mult" then 
    Deg:=degree(_f, [_var]);
    if Deg=FAIL then
      return([[[0,0]], [[0,0]], [[0]]] )
    end_if;

    if not has(normal(_f/_var^Deg), _var) then
      expo:=1; expos:=expos.[[expo]];
      _coeff:=[coeff(poly(_f, [_var]),_var,j) $ j=0..Deg ];
      code:=code.[[expo,_plus(2^(j-1)*
             IntTrans::zero_one(_coeff[j]) $ j=1..Deg+1)]];
      OPS:=OPS.[_coeff];
    else
      for i from 1 to nops(_f) do 
        _g:=op(_f, i);
        if type(_g)="_power" then
          expo:=op(_g,2);

          if not testtype(expo, Type::Numeric) then
            expos:=expos.[[expo]]; expo:=0; 
          else
            expos:=expos.[[expo]];
          end_if;
          _g:=op(_g,1);
        else
          expo:=1; expos:=expos.[[expo]];
        end_if;

        Deg:=degree(_g, [_var]); 
        if Deg=FAIL then
          return([[[0,0]], [[0,0]], [[0]]] )
        end_if;
        _coeff:=[coeff(poly(_g, [_var]),_var,j) $ j=0..Deg ];
        if has(_coeff[1], _var) then
          return( [[[0,0]], [[0,0]], [[0]]]   );
        end_if;

        code:=code.[[expo,_plus(2^(j-1)*IntTrans::zero_one(_coeff[j]) $ j=1..Deg+1)]];
        OPS:=OPS.[_coeff];
      end_for;
    end_if;


  else

      _g:=_f;

      if type(_g)="_power" then
        expo:=op(_g,2);
        _g:=op(_g,1);

        if not testtype(expo, Type::Numeric) then
          expos:=expos.[[expo]]; expo:=0;
        else
          expos:=expos.[[expo]];
        end_if;

      else
        expo:=1; expos:=expos.[[expo]];
      end_if;
      /*
      if expo<0 then
        return([[[0,0]], [[0,0]], [[0]]]);
      end_if;
*/
      Deg:=degree(_g, [_var]); 

      if Deg=FAIL then
        return([[[0,0]], [[0,0]], [[0]]])
      end_if;
      _coeff:=[coeff(poly(_g, [_var]),_var,j) $ j=0..Deg];
      if has(_coeff[1], _var) then
        return([[[0,0]], [[0,0]], [[0]]]);
      end_if;

      code:=code.[[expo, _plus(2^(j-1)*
            IntTrans::zero_one(_coeff[j]) $ j=1..Deg+1)]];
      OPS:=OPS.[_coeff];
    
  end_if;
  return([code, OPS, expos]);

end_proc:


IntTrans::ratfunc_test:=proc(_f, pat)
local Num, Den;
begin
  if testtype(_f,Type::RatExpr(pat)) then
    Num:=numer(_f); Den:=denom(_f);
    return(Num, Den);
  end_if;
  FAIL;
end_proc:


// ---- S.H. Sept. 2002--------------------------------------
// is going to be obsolete using stdlib::hasmsign instead
IntTrans::Minus:=proc(_z)
begin
  if testtype(_z, Type::Real) then
    if _z<0 then
      return(TRUE);
    end_if;
  elif type(_z)="_mult" then
    if testtype( op(_z, nops(_z)), Type::Real) then
      if op(_z, nops(_z))<0 then
        return(TRUE)
      end_if;
    end_if;
  end_if;
  FALSE;
end_proc:
// -------------------------------

/*--
  computes the integral-transform of built in functions  
  if the computation is impossible, FAIL will be returned 
--*/
IntTrans::builtin:=proc(T) local _f, var1, var2, tmp;
begin
  _f:=extop(T,1); var1:=extop(T,2); var2:=extop(T,3); 
  tmp:=eval(op(_f, 0));
  if type(tmp)=DOM_FUNC_ENV then
    return( slot(tmp, type(T))(_f, var1, var2) )
  end_if;  
  FAIL;
end_proc:


/*--
   linearity of integral transforms 
--*/
IntTrans::linear:=proc(T, flag) 
  local _f, var1, var2, typ, nps, arg, _c, _s;
begin
  _f:=extop(T, 1); var1:=extop(T, 2); var2:=extop(T, 3);
  typ:=type(_f); arg:=op(_f); nps:=nops(_f);
  if typ="_plus" then 
    userinfo(3,"linear and additive");
    return( _plus(map(op(_f), eval(text2expr(type(T))), var1, var2)))
  elif typ="_mult" then
     _s:=select(_f, has, var1);

     //---------------------------------------------------
     // Walter, 4.5.2000:
     // The following normalization helps in some cases.
     // On the other hand, it does not seem to work well
     // with the pattern matcher, because normalization
     // messes up certain rational patterns.
     // Use this normalization only on request, i.e., when
     // calling IntTrans::linear with a second (dummy)
     // argument. This may be reasonable, if a first run
     // without this normalization returns FAIL:
     if args(0) = 2 then
       _s:=normal(numer(_s))/factor(denom(_s));
     end_if:
     //---------------------------------------------------

     // do a syntactic check first
     if _f = _s then
       return(FAIL)
     end_if;
    
     _c:=normal(_f/_s); // noetig,  da t^n/t^n nicht gekuerzt wird 
     // _c:=combine(_c, exp); // activate this if the kernel problem with exp
                              // cannot  be solved 
                              
     if not iszero(_c - 1) then
       userinfo(3,"linear and multiplicative");
       return(_c*eval(text2expr(type(T))(_s, var1, var2)))
     else
       return(FAIL);
     end_if;
  else
     return(FAIL);
  end_if;
end_proc:

/*--
   transforms the D-Operator into diff 
--*/
IntTrans::D2diff:=proc(_f) local i, j, dop, var;
begin
  dop:=op(_f,0); var:=op(_f,1);
  if nops(dop)=1 then
    if domtype(op(dop))=DOM_IDENT then
      return( diff(op(dop)(var),var))
    elif type(op(_f,0))="D" then
      return( diff(IntTrans::D2diff( op(dop)(var)),var) )
    end_if;
  else
    var:=op(op(_f,0),1);
    diff( op(dop, 2)(op(_f, i) $ i=1..nops(_f)), op(_f, op(var[j])) $ j=1..nops(var));
  end_if;
end_proc:

// ---- S.H. Sept. 2002--------------------------------------
// Sorting the lists in nonrat_ana 
IntTrans::sort_n:=proc(L1, L2, L3, L4)
	local S1, S2, S3, S4, length,i,j;
begin
	S2:=[];
	S3:=[];
	S4:=[];
	S1:=sort(L1);
	length := nops(L1);
	// syncronize lists, till all is gone ...
	for i from 1 to length do
		j := contains(L1,S1[i]);
		S2:=S2.[L2[j]];
		S3:=S3.[L3[j]];
		S4:=S4.[L4[j]];
		delete L1[j];
		delete L2[j];
		delete L3[j];
		delete L4[j];
	end_for;
	return(S1, S2, S3, S4);
end_proc;
// ---------------------------------------------------

IntTrans::funcpos:= proc() begin (contains(map([op(args(1))],type),args(2))) end_proc :
IntTrans::sign:=proc() begin op( sign(args(1)),nops(sign(args(1)))) end_proc  :
IntTrans::zero_one:=proc() begin (if args(1)<>0 then return(1) else return(0) end_if; ) end_proc :
IntTrans::anatype:=proc() begin (if nops(args(1))=1 then [type(args(1))] else [map(op(args(1)), type)] end_if) end_proc :
IntTrans::anapols:=proc() begin map(args(1), IntTrans::anapol, args(2)) end_proc :
IntTrans::split2:=proc() begin  (if testtype(args(1), Type::RatExpr(args(2) ) ) then [args(1), 1] end_if; select(args(1), testtype, Type::RatExpr(args(2))); if %=1 then return([1, args(1)]) end_if;  [last(2), args(1)/last(2)]) end_proc :

unalias( IntTrans ):

// end of file 
