// Dirk Mueller, olorien, 28/10/96, v1.0 

alias( IntTrans = transform::IntTrans ):

ln::"transform::invlaplace":=
  proc(_f, var1, var2) 
    local _a, _b, _g, Num, Den, ana_Num, ana_Den;
  begin
    _g:=op(_f);
    case type(_g)
    of "_power" do
      if op(_g,2)=1/2 then
        _g:=op(_g,1);
        if testtype(_g, Type::RatExpr(var1)) then
          Num:=numer(_g); Den:=denom(_g);
          ana_Num:=IntTrans::anapol(Num, var1);
          ana_Den:=IntTrans::anapol(Den, var1);
          case [ana_Num[1][1], ana_Den[1][1]]
          of [[1,3],[1,3]] do
            if ana_Num[2][1][2]=1 and ana_Den[2][1][2]=1 then
              _a:=ana_Num[2][1][1]; 
              if _a=-ana_Den[2][1][1] then // ln(sqrt(s+a)/(s-a))
                userinfo(10, "formula 63 from Heuser");
                return( sinh(_a*var2)/var2 );
              end_if;
            end_if;
            break;

          of [[1,5],[1,5]] do
            if ana_Num[2][1][3]=1 and ana_Den[2][1][3]=1 then
              _a:=specfunc::Wurzelbehandlung(ana_Num[2][1][1]); 
              _b:=specfunc::Wurzelbehandlung(ana_Den[2][1][1]);
              userinfo(10, "formula 64 from Heuser");
              // ln(sqrt( (s^2 + a)/(s^2 - a)))
              return( (cos(_b*var2)-cos(_a*var2))/var2 );
            end_if;
          end_case;          
        end_if;
      end_if;

    of "_mult" do
      if testtype(_g, Type::RatExpr(var1)) then
        Num:=numer(_g); Den:=denom(_g);
        ana_Num:=IntTrans::anapol(Num, var1);
        ana_Den:=IntTrans::anapol(Den, var1);

        case [ana_Num[1][1], ana_Den[1][1]]
        of [[1,3],[1,3]] do
          if ana_Num[2][1][2]=1 and ana_Den[2][1][2]=1 then
            _a:=-ana_Num[2][1][1]; _b:=-ana_Den[2][1][1];
            userinfo(10, "formula 62 from Heuser");
            // ln((s-a)/(s-b))
            return( (exp(_b*var2)-exp(_a*var2))/var2 );
          end_if;  
        end_case;
      end_if;
      break;

    of "_plus" do
      _a:=_g-var1;
      if not has(_a, var1) then
        userinfo(10, "formula from M&P");
        return(-exp(-_a*var2)/var2);
      end_if;

    end_case;
    FAIL;
  end_proc:

unalias( IntTrans ):

// end of file 

