// Dirk Mueller, olorien, 28/10/96, v1.0 

alias( IntTrans = transform::IntTrans ):

_power::"transform::invlaplace":= //transform d. IntTrans ersetzt
  proc(_fu, var1, var2) 
    local Den, Den_L, Den_code, Den_nmb,
          _w, _a, _b, _b2, _c2, _n;
  begin
    case _fu

    of 1/var1 do
      userinfo(10, "formula 1 from Heuser");
      return(1);
    of 1/sqrt(var1) do
      userinfo(10, "formula 50 from Heuser");
      return(1/sqrt(PI*var2));
    end_case;

    Den:= denom(_fu);

    if not testtype(Den, Type::PolyExpr(var1)) then
       return(FAIL);
    end_if;

    Den_L:=IntTrans::anapol(Den, var1);
    if Den_L=FAIL then
      return(FAIL);
    end_if;

    Den_code:={op(Den_L[1])}; Den_nmb:=nops(Den_L[1]);

    case [Den_code, Den_nmb]
    of [{[1,5]}, 1] do // 1/(a*s^2+b) 
      _a:=Den_L[2][1][3]; _b2:=Den_L[2][1][1]/_a;
      if IntTrans::Minus(_b2) then
        _b:=specfunc::Wurzelbehandlung(-_b2);
        userinfo(10, "formula 8 from Heuser");
        return(sinh(_b*var2)/_a/_b);
      end_if;
      _b:= specfunc::Wurzelbehandlung(_b2);
      userinfo(10, "formula 7 from Heuser");
      return(sin(_b*var2)/_a/_b);

    of [{[2,5]}, 1] do // 1/(a*s^2+b)^2 
      _a:=Den_L[2][1][3]; _b:=Den_L[2][1][1]/_a;
      if IntTrans::Minus(_b) then
        _b:=specfunc::Wurzelbehandlung(-_b); 
        userinfo(10, "formula 31 from Heuser");
        return((-sinh(_b*var2) + _b*var2*cosh(_b*var2))/_a^2/_b^3/2);
      end_if;
      _b:=specfunc::Wurzelbehandlung(_b);
      userinfo(10, "formula 30 from Heuser");
      return((sin(_b*var2)-_b*var2*cos(_b*var2))/_a^2/_b^3/2 );

    of [{[1,7]}, 1] do  // 1/(a*s^2+b*s+c) 
      _a:=Den_L[2][1][3]; 
      _b:=Den_L[2][1][2]/_a/2;
      _c2:=Den_L[2][1][1]/_a; 
      _w:=normal(_c2 - _b^2);
      
      if is(_w > 0)=TRUE then
        _w:=specfunc::Wurzelbehandlung(_w);
        userinfo(10, "formula 9 from Heuser, case 1");
        return(exp(-_b*var2)*sin(_w*var2)/_w/_a );
      elif is(_w < 0)=TRUE then
        _w:=specfunc::Wurzelbehandlung(-_w);
        userinfo(10, "formula 9 from Heuser, case 2");
        return(exp(-_b*var2)*sinh(_w*var2)/_w/_a );
      elif is(_w = 0)=TRUE then
        userinfo(10, "formula 9 from Heuser, case 3");
        return(var2*exp(-_b*var2)/_a);
      else // symbolic case, we should return something
	   // S.Huckemann Oct 2003
        userinfo(10, "formula 9 from Heuser, case 2");
        if stdlib::hasmsign(_w) then 
           _w:=specfunc::Wurzelbehandlung(-_w);
           return(exp(-_b*var2)*sinh(_w*var2)/_w/_a );	   
        else
           _w:=specfunc::Wurzelbehandlung(_w);
           return(exp(-_b*var2)*sin(_w*var2)/_w/_a );	   
        end_if;
      end_if;

    of [{[1,17]}, 1] do // 1/(a*s^4+b) 
      _a:=Den_L[2][1][5]; 
      _b:=Den_L[2][1][1]/_a;
      if IntTrans::Minus(_b) then
        _b:= specfunc::Wurzelbehandlung(specfunc::Wurzelbehandlung(-_b));
        userinfo(10, "formula 32 from Heuser");
        return((sinh(_b*var2)-sin(_b*var2) )/_b^3/2/_a);
      end_if;
      _b:= specfunc::Wurzelbehandlung(specfunc::Wurzelbehandlung(_b/4));
      userinfo(10, "formula 28 from Heuser");
      return(( sin(_b*var2)*cosh(_b*var2)-cos(_b*var2)*sinh(_b*var2))/_b^3/_a/4);

    end_case; // [Den_code, Den_nmb] 

    if Den_nmb=1 then
      case Den_L[1][1][2]
      of 2 do
        _n:=Den_L[3][1][1]; 
        if is(_n>0)=TRUE then     // s^(-n)
          userinfo(10, "formula 44 from Heuser");
          return(var2^(_n-1)/gamma(_n));
        end_if;
        break;

      of 3 do 
        _n:=Den_L[3][1][1];    
        if is(_n>0)=TRUE then // (a*s + b)^(-n)
          _a:=Den_L[2][1][2]; _b:=Den_L[2][1][1]/_a;
          userinfo(10, "formula 45 from Heuser");
          return( var2^(_n-1)*exp(-_b*var2)/gamma(_n)/_a^(_n ));
        end_if;
        break;

      end_case;
    end_if;

    return(FAIL);
  end_proc:


unalias( IntTrans ):

// end of file 
