// laplace(Ci(a*t), t, s) = -1/2*ln(1 + s^2/a^2)/s, a > 0

Ci::"transform::laplace":=
  proc(f, t, s) 
    local g, a, b;
  begin
    // f = Ci(g(t)); g = g(t)
    g:= expand(op(f));
    // only g = a*t + b can be treated:
    a:= diff(g, t);
    if has(a, t) then
       return(FAIL);
    end_if;
    // In fact, only b = 0 can be treated:
    b:= subs(g, t = 0, EvalChanges);
    if not iszero(b) then
       return(FAIL);
    end_if;
    // the following relation seems to hold for
    // any nonzero real or complex value of a:
    return(ln(a)/s - ln(s^2+a^2)/2/s);
  end_proc:

// end of file 
