// Dirk Mueller, olorien, 28/10/96, v1.0 
// laplace(Ei(a*t), t, s) = ln(1 + s/a)/s)

Ei::"transform::laplace":=
  proc(f, t, s) 
    local g, a, b;
  begin
    // f = Ei(g(t)); g = g(t)
    if nops(f) = 1 or
      (nops(f) = 2 and op(f, 1) = 1) then
      g:= expand(op(f));
      // only g = a*t + b can be treated:
      a:= diff(g, t);
      if has(a, t) then
         return(FAIL);
      end_if;
      // In fact, only b = 0 can be treated:
      b:= subs(g, t = 0, EvalChanges);
      if not iszero(b) then
         return(FAIL);
      end_if;
      userinfo(10, "formula 19.1 from R&K");
      // The following formula holds for arbitrary complex values 
      // of a and s satisfying Re(s) > Re(a):
      return(ln(a)/2/s - ln(1/a)/2/s - ln(s-a)/s);
    end_if:
    if nops(f) = 2 and op(f)  then

    end_if:
    FAIL;
  end_proc:

// end of file 
