// Dirk Mueller, olorien, 28/10/96, v1.0 

exp::"transform::laplace":=
  proc(_f, var1, var2) 
    local ana, _a, _b, _g;
  begin
    _g:=expand(op(_f));
    _a:=normal(_g/var1);
    if not has(_a, var1) then
      return(1/(var2-_a))
    else
      if testtype(_g, Type::RatExpr(var1)) then
        ana:=transform::IntTrans::anapol(_g, var1);
        case ana[1][1]
        of [1, 3] do
          _a:=ana[2][1][2]; _b:=ana[2][1][1];
          userinfo(10, "formula from M&P");
          return( exp(_b)/(var2-_a));
        end_case;
      end_if;
    end_if;
    // S.H. 9/2002 we also want to transform exp(_a/var1)
    _a:=_g*var1;
    if not has( _a, var1) then
      return(transform::laplace::compute_x_n_exp_c_over_x(1,0,_a,_f,
                                                          var1, var2));
    end_if;
    FAIL;
  end_proc:

// end of file 
