// Dirk Mueller, olorien, 28/10/96, v1.0 

heaviside::"transform::laplace":=
  proc(_f, var1, var2) 
    local _a, _b, ana, _g, erg, erg1;
  begin
    _g:=expand(op(_f));
    _a:=normal(_g/var1);

    if not has(_a, var1) then
       erg:=is(_a>0);
       if erg=TRUE then
         userinfo(10, "formula from M&P");
         return(1/var2) ;
       elif erg=FALSE then
         userinfo(10, "formula from M&P");
         return(0);
       end_if;
       return(FAIL);
    end_if;

    if testtype(_g, Type::RatExpr(var1)) then
      ana:=transform::IntTrans::anapol(_g, var1);
      case ana[1][1]
      of [1,3] do
        _a:=ana[2][1][2];  // heavside(_a*x + _b) 
        _b:=ana[2][1][1];
        if testtype(_a, Type::Real) then
          erg1:=is(_a>0); 
          if erg1=TRUE then
            if is(_b >= 0) = TRUE then
              userinfo(10, "formula from M&P");
              return(1/var2)          
            elif is(_b <= 0) = TRUE then
               userinfo(10, "formula from M&P");
               return( exp(_b/_a*var2)/var2 );
            end_if;
          elif erg1 = FALSE then
            if is(_b>= 0) = TRUE then
              userinfo(10, "formula from M&P");
              return(  (1-exp(_b/_a*var2))/var2 );
            elif is(_b <= 0) = TRUE then
              userinfo(10, "formula from M&P");
              return(0);
            end_if;
          end_if;
          return(FAIL);
        end_if;
      end_case;
    end_if;
    FAIL;
  end_proc:

// end of file 
