// Dirk Mueller, olorien, 28/10/96, v1.0 

_power::"transform::laplace":=
  proc(_fu, var1, var2) 
    local _n, _f, _a, /*erg,*/ i, j;
  begin

    _f:=op(_fu,1); _n:=op(_fu, 2);
    // ---------------- by Stephan Huckemann April 2002 -----
    // Laplace((a*x)^b,x,t) = t^(-b-1)*a^b*gamma(b+1)
    // whenever Re(b) > -1, cf. Oberhettinger's tables of 
    // L - transforms, No. 3.3
    // ------------------------------------------------------
    _a:=_f/var1;
    if not has(_a, var1) then 
	   if (testtype(_n,Type::Numeric) and (Re(_n) > -1))
		or // symbolic case and assumption
	      (not testtype(_n,Type::Numeric) and (is(Re(_n) > -1)= TRUE)) then
	        return(_a^_n*gamma(_n+1)/var2^(_n+1));
            elif not testtype(_n,Type::Numeric) then // erg=UNKNOWN
	        userinfo(1, "please specify constant");
            end_if;
            return(FAIL);
    end_if;

    case type(_f)
      of "sin" do
        _a:=op(_f)/var1;
        if not has(_a, var1) then
          if testtype(_n, Type::PosInt) then
            if type(_n/2)=DOM_INT then
              _n:=_n/2;
              userinfo(10, "formula 5.9 from R&K");
              return( (2*_n)!*_a^(2*_n)/ 
                (var2*_mult(var2^2+(2*i)^2*_a^2 $ i=1.._n)) );
              //sin(a*t)^(2*n)
            else
              _n:=(_n-1)/2;
              userinfo(10, "formula 5.10 from R&K");
              return( (2*_n+1)!*_a^(2*_n+1)/ 
                _mult(var2^2+(2*i+1)^2*_a^2 $ i=0.._n) );
              //sin(a*t)^(2*n+1)
            end_if;
          end_if;
        end_if;
        return(FAIL);

      of "cos" do
        _a:=op(_f)/var1;
        if not has(_a, var1) then
          if testtype(_n, Type::PosInt) then
            if type(_n/2)=DOM_INT then
              _n:=_n/2;
              userinfo(10, "formula 5.28 from R&K");
              return( expand( (2*_n)!*_a^(2*_n)*
                      (1+_plus( _mult(var2^2+4*(j*_a-_a)^2 $ j=1..i)/
                        ((2*i)!*_a^(2*i))
                                     $ i=1.._n)
                       ))/
                       (var2*_mult( var2^2+(2*i*_a)^2 $ i=1.._n))
                    );
            else
              _n:=(_n-1)/2;
              userinfo(10, "formula 5.29 from R&K"); 
              return(expand( (2*_n+1)!*_a^(2*_n)*var2*
                      ( 1+_plus( 
                        _mult( var2^2+(2*j*_a-_a)^2 $ j=1..i)/
                            ((2*i+1)!*_a^(2*i))
                                      $ i=1.._n)
                    
                      ))/_mult( var2^2+(2*i*_a+_a)^2 $ i=0.._n)
                    );
            end_if;
          end_if; 
        end_if;
        return(FAIL);

      of "sinh" do
        _a:=op(_f)/var1;
        if not has(_a, var1) then
          if testtype(_n, Type::PosInt) then
            if type(_n/2)=DOM_INT then //sinh(a*t)^(2*n)
              _n:=_n/2;
              userinfo(10, "formula 7.4 from R&K");
              return( (2*_n)!*_a^(2*_n)/ 
                      (var2*_mult( var2^2-i^2*(2*_a)^2 $ i=1.._n)) );
            else //sinh(a*t)^(2*n+1)
              _n:=(_n-1)/2;
              userinfo(10, "formula 7.5 from R&K");
              return( (2*_n+1)!*_a^(2*_n+1)/ 
                _mult(var2^2-(2*i+1)^2*_a^2  $ i=0.._n) );
            end_if;
          end_if;
        end_if;
        return(FAIL);

      of "cosh" do
        _a:=op(_f)/var1;
        if not has(_a, var1) then
          if testtype(_n, Type::PosInt) then
            if type(_n/2)=DOM_INT then //cosh(a*t)^(2*n)
              _n:=_n/2;
              return( (2*_n)!*(-1)^_n*_a^(2*_n)/ 
                      (var2*_mult( var2^2-i^2*(2*_a)^2 $ i=1.._n))
                    * _plus(1/(-_a^2)^j / (2*j)! * _mult( var2^2-i^2*(2*_a)^2 $ i=0..j-1) $ j = 0.._n)
                    );
            else //cosh(a*t)^(2*n+1)
              _n:=(_n-1)/2;
              return( (2*_n+1)!* (-1)^_n* _a^(2*_n) * var2
                      / _mult(var2^2-(2*i+1)^2*_a^2  $ i=0.._n) 
                    * _plus(1/(-_a^2)^j / (2*j+1)! * _mult( var2^2-(2*i+1)^2*_a^2 $ i=0..j-1) $ j = 0.._n)
                    );
            end_if;
          end_if;
        end_if;
        return(FAIL);

    end_case;
    
  FAIL;
  end_proc:

// end of file 

