// Globale Annahmen:
// Variable der Originalfunktion: s
// Variable der Transformierten:  t
// a, b, c, ..., v, w, y sind von s unabhngig
// m, n, m0, n0 positiv und ganzzahlig
// m2, n2 positiv, ganzzahlig, gerade
// m1, n1 positiv, ganzzahlig, ungerade
// m3, n3 ganzzahlig
// mp1 = m+1
// m_ = -m, n_ = -n, m0_ = -m0, n0_ = -n0
// fx, gx, f1x, g1x are unrestricted

// Diese Datei wird aus compile_invpatterns.mu heraus gelesen.

alias(bl=matchlib::block):
alias(Wb=hold(specfunc::Wurzelbehandlung)):

invlaplace_patterns:=
[
 [(a*s + b)^c, exp(-t*b/a)*t^(-c-1)*a^c/gamma(-c), [a > 0, Re(c) < 0]],
 [1/(a*s + b)^c, exp(-t*b/a)*t^(c-1)/a^c/gamma(c), [a > 0, Re(c) > 0]],
 [(a*s + b)^c, exp(-t*b/a)*t^(-c-1)*a^c/gamma(-c), [-c in N_]],
 [1/(a*s + b)^c, exp(-t*b/a)*t^(c-1)/a^c/gamma(c), [ c in N_]],

 [1/s/(b + c*exp(d*s)),    bl(1/(b+c)*(1-(-b/c)^floor(t/d))), 
           [d<>0, b+c<>0, bl(not iszero(c)), bl(not iszero(b))]],
 [1/s/(b + c*exp(d*s)),    bl(-floor(t/d)/b), [d<>0, c+b=0, bl(not iszero(b))]],
 [1/s/(b + c*exp(d*s)),    bl(1/(b+c)), [d=0, b+c<>0 /*, bl(sysorder(b,c))*/, bl(not iszero(b))]],

 [1/(b*s + c*s*exp(d*s)),  bl(1/(b+c)*(1-(-b/c)^floor(t/d))), [d<>0, b+c<>0, bl(not iszero(b))]],
 [1/(b*s + c*s*exp(d*s)),  bl(-floor(t/d)/b), [d<>0, c+b=0, bl(not iszero(b))]],
 [1/(b*s + c*s*exp(d*s)),  bl(1/(b+c)), [d=0, b+c<>0 /*, bl(sysorder(b,c))*/, bl(not iszero(b))]],

 [1/s^2/(b + c*exp(d*s)),
  bl((t+(-b/c)^floor(t/d)*(floor(t/d)*d-t))/(b+c) +c/(b+c)^2*d*(-1+(-b/c)^floor(t/d))),
  [d<>0, b+c<>0, bl(not iszero(b))]
 ],
 [1/s^2/(b + c*exp(d*s)),
  bl(1/2/b*(d*floor(t/d)^2-floor(t/d)*(2*t-d))),
  [d<>0, c+b=0, bl(not iszero(b))]
 ],
 [1/s^2/(b + c*exp(d*s)),
  bl(t/(b+c)),
  [d=0, b+c<>0, /*bl(sysorder(b,c)),*/ bl(not iszero(b))]],


 [1/s/(b*s + c*s*exp(d*s)),
  bl((t+(-b/c)^floor(t/d)*(floor(t/d)*d-t))/(b+c) +c/(b+c)^2*d*(-1+(-b/c)^floor(t/d))),
  [d<>0, b+c<>0, bl(not iszero(b))]
 ],
 [1/s/(b*s + c*s*exp(d*s)),
  bl(1/2/b*(d*floor(t/d)^2-floor(t/d)*(2*t-d))),
  [d<>0, c+b=0, bl(not iszero(b))]
 ],
 [1/s/(b*s + c*s*exp(d*s)),
  bl(t/(b+c)),
  [d=0, b+c<>0 /*, bl(sysorder(b,c))*/]],
 [1/(b*s^2 + c*s^2*exp(d*s)),
  bl((t+(-b/c)^floor(t/d)*(floor(t/d)*d-t))/(b+c) +c/(b+c)^2*d*(-1+(-b/c)^floor(t/d))),
  [d<>0, b+c<>0, bl(not iszero(b))]
 ],
 [1/(b*s^2 + c*s^2*exp(d*s)),
  bl(t/(b+c)), 
  [d=0, b+c<>0, /*bl(sysorder(b,c)),*/ bl(not iszero(b))]],
 [1/(b*s^2 + c*s^2*exp(d*s)),
  bl(1/2/b*(d*floor(t/d)^2-floor(t/d)*(2*t-d))),
  [d<>0, c+b=0, bl(not iszero(b))]
 ],

//=========================================
 [1/s/(b*exp(d*s) + c*exp(e*s)),
     bl(heaviside(t - d)/(b+c)*(1-(-b/c)^floor((t - d)/(e - d)))),
     [e>d, b+c<>0, bl(not iszero(b)), bl(not iszero(c))]],
 [1/s/(b*exp(d*s) + c*exp(e*s)),
     bl(heaviside(t - e)/(b+c)*(1-(-c/b)^floor((t - e)/(d - e)))),
     [e<d, b+c<>0, bl(not iszero(b)), bl(not iszero(c))]],
 [1/s/(b*exp(d*s) + c*exp(e*s)),
     bl(heaviside(t - d)/(b+c)),
     [e=d, b+c<>0, bl(sysorder(d, e)), bl(not iszero(b)), bl(not iszero(c))]],
 [1/s/(b*exp(d*s) + c*exp(e*s)),
     bl(-heaviside(t - d)*floor((t-d)/(e-d))/b),
     [e>d, b+c=0, bl(not iszero(b)), bl(not iszero(c))]],
 [1/s/(b*exp(d*s) + c*exp(e*s)),
     bl(-heaviside(t - e)*floor((t-e)/(d-e))/c),
     [e<d, b+c=0, bl(not iszero(b)), bl(not iszero(c))]],
//======
 [1/(s*b*exp(d*s) + s*c*exp(e*s)),
     bl(heaviside(t - d)/(b+c)*(1-(-b/c)^floor((t - d)/(e - d)))),
     [e>d, b+c<>0, bl(not iszero(b)), bl(not iszero(c))]],
 [1/(s*b*exp(d*s) + s*c*exp(e*s)),
     bl(heaviside(t - e)/(b+c)*(1-(-c/b)^floor((t - e)/(d - e)))),
     [e<d, b+c<>0, bl(not iszero(b)), bl(not iszero(c))]],
 [1/(s*b*exp(d*s) + s*c*exp(e*s)),
     bl(heaviside(t - d)/(b+c)),
     [e=d, b+c<>0, bl(sysorder(d, e)), bl(not iszero(b)), bl(not iszero(c))]],
 [1/(s*b*exp(d*s) + s*c*exp(e*s)),
     bl(-heaviside(t - d)*floor((t-d)/(e-d))/b),
     [e>d, b+c=0, bl(not iszero(b)), bl(not iszero(c))]],
 [1/(s*b*exp(d*s) + s*c*exp(e*s)),
     bl(-heaviside(t - e)*floor((t-e)/(d-e))/c),
     [e<d, b+c=0, bl(not iszero(b)), bl(not iszero(c))]],
//=========================================
//=========================================
 [1/s^2/(b*exp(d*s) + c*exp(e*s)),
     bl(heaviside(t-d)*(t-d +(-b/c)^floor((t-d)/(e-d))*(floor((t-d)/(e-d))*(e-d)-(t-d)))/(b+c)
     +c/(b+c)^2*(e-d)*heaviside(t-d)*(-1+(-b/c)^floor((t-d)/(e-d)))),
     [e>d, b+c<>0, bl(not iszero(b)), bl(not iszero(c))]],
 [1/s^2/(b*exp(d*s) + c*exp(e*s)),
     bl(heaviside(t-e)*(t-e +(-c/b)^floor((t-e)/(d-e))*(floor((t-e)/(d-e))*(d-e)-(t-e)))/(b+c)
     +b/(b+c)^2*(d-e)*heaviside(t-e)*(-1+(-c/b)^floor((t-e)/(d-e)))),
     [e<d, b+c<>0, bl(not iszero(b)), bl(not iszero(c))]],
 [1/s^2/(b*exp(d*s) + c*exp(e*s)),
     bl(heaviside(t-d)*(t-d)/(b+c)),
     [e=d, b+c<>0, bl(sysorder(d, e)), bl(not iszero(b)), bl(not iszero(c))]],
 [1/s^2/(b*exp(d*s) + c*exp(e*s)),
     bl(1/2/b*((e -d)*floor((t-d)/(e-d))^2-floor((t-d)/(e-d))*(2*t-d-e))),
     [e>d, b+c=0, bl(not iszero(b)), bl(not iszero(c))]],
 [1/s^2/(b*exp(d*s) + c*exp(e*s)),
     bl(1/2/c*((d -e)*floor((t-e)/(d-e))^2-floor((t-e)/(d-e))*(2*t-e-d))),
     [e<d, b+c=0, bl(not iszero(b)), bl(not iszero(c))]],
//======
 [1/s/(b*s*exp(d*s) + c*s*exp(e*s)),
     bl(heaviside(t-d)*(t-d +(-b/c)^floor((t-d)/(e-d))*(floor((t-d)/(e-d))*(e-d)-(t-d)))/(b+c)
     +c/(b+c)^2*(e-d)*heaviside(t-d)*(-1+(-b/c)^floor((t-d)/(e-d)))),
     [e>d, b+c<>0, bl(not iszero(b)), bl(not iszero(c))]],
 [1/s/(s*b*exp(d*s) + s*c*exp(e*s)),
     bl(heaviside(t-e)*(t-e +(-c/b)^floor((t-e)/(d-e))*(floor((t-e)/(d-e))*(d-e)-(t-e)))/(b+c)
     +b/(b+c)^2*(d-e)*heaviside(t-e)*(-1+(-c/b)^floor((t-e)/(d-e)))),
     [e<d, b+c<>0, bl(not iszero(b)), bl(not iszero(c))]],
 [1/s/(s*b*exp(d*s) + s*c*exp(e*s)),
     bl(heaviside(t-d)*(t-d)/(b+c)),
     [e=d, b+c<>0, bl(sysorder(d, e)), bl(not iszero(b)), bl(not iszero(c))]],
 [1/s/(s*b*exp(d*s) + s*c*exp(e*s)),
     bl(1/2/b*((e -d)*floor((t-d)/(e-d))^2-floor((t-d)/(e-d))*(2*t-d-e))),
     [e>d, b+c=0, bl(not iszero(b)), bl(not iszero(c))]],
 [1/s/(s*b*exp(d*s) + s*c*exp(e*s)),
     bl(1/2/c*((d -e)*floor((t-e)/(d-e))^2-floor((t-e)/(d-e))*(2*t-e-d))),
     [e<d, b+c=0, bl(not iszero(b)), bl(not iszero(c))]],
//======
 [1/(s^2*b*exp(d*s) + s^2*c*exp(e*s)),
     bl(heaviside(t-d)*(t-d +(-b/c)^floor((t-d)/(e-d))*(floor((t-d)/(e-d))*(e-d)-(t-d)))/(b+c)
     +c/(b+c)^2*(e-d)*heaviside(t-d)*(-1+(-b/c)^floor((t-d)/(e-d)))),
     [e>d, b+c<>0, bl(not iszero(b)), bl(not iszero(c))]],
 [1/(s^2*b*exp(d*s) + s^2*c*exp(e*s)),
     bl(heaviside(t-e)*(t-e +(-c/b)^floor((t-e)/(d-e))*(floor((t-e)/(d-e))*(d-e)-(t-e)))/(b+c)
     +b/(b+c)^2*(d-e)*heaviside(t-e)*(-1+(-c/b)^floor((t-e)/(d-e)))),
     [e<d, b+c<>0, bl(not iszero(b)), bl(not iszero(c))]],
 [1/(s^2*b*exp(d*s) + s^2*c*exp(e*s)),
     bl(heaviside(t-d)*(t-d)/(b+c)),
     [e=d, b+c<>0, bl(sysorder(d, e)), bl(not iszero(b)), bl(not iszero(c))]],
 [1/(s^2*b*exp(d*s) + s^2*c*exp(e*s)),
     bl(1/2/b*((e -d)*floor((t-d)/(e-d))^2-floor((t-d)/(e-d))*(2*t-d-e))),
     [e>d, b+c=0, bl(not iszero(b)), bl(not iszero(c))]],
 [1/(s^2*b*exp(d*s) + s^2*c*exp(e*s)),
     bl(1/2/c*((d -e)*floor((t-e)/(d-e))^2-floor((t-e)/(d-e))*(2*t-e-d))),
     [e<d, b+c=0, bl(not iszero(b)), bl(not iszero(c))]],
//=========================================
//=========================================
 [ln(e), ln(e)*dirac(t), []],

 [ln(e*(a*s + b)^f), 
     bl(ln(e*a^f)*dirac(t) 
      + f*transform::frozenInvlaplace(ln(s), s, t) 
      + f*(1 - exp(-b/a*t))/t),
     [bl(not iszero(a)), bl(not iszero(f))]],
 [ln(e*(a + b/s)^f), 
     bl(ln(e*a^f)*dirac(t) 
      + f*(1 - exp(-b/a*t))/t),
     [bl(not iszero(a)), bl(not iszero(f))]],
 [ln(e*(g*(a*s+b)/(c*s+d))^f),
     ln(e*(g*a/c)^f)*dirac(t) 
     + f*exp(-d*t/c)/t 
     - f*exp(-b*t/a)/t, 
     [bl(not iszero(a)), bl(not iszero(c)), bl(not iszero(f)), bl(not iszero(a*d + b*c))]],
 [ln(e*(g*(a+b/s)/(c+d/s))^f),
     ln(e*(g*a/c)^f)*dirac(t) 
     + f*exp(-d*t/c)/t 
     - f*exp(-b*t/a)/t, 
     [bl(not iszero(a)), bl(not iszero(c)), bl(not iszero(f)), bl(not iszero(a*d + b*c))]],

 [ln(e*(a*s+b)^f/(c*s+d)^g), 
     bl(ln(e*a^f/c^g)*dirac(t)
     + (f-g)*transform::frozenInvlaplace(ln(s), s, t) 
     + f*(1 - exp(-b*t/a))/t
     - g*(1 - exp(-d*t/c))/t), 
     [bl(not iszero(a)), bl(not iszero(c)), bl(not iszero(f)), bl(not iszero(a*d + b*c))]],
 [ln(e*(a+b/s)^f/(c+d/s)^g), 
     bl(ln(e*a^f/c^g)*dirac(t)
     + f*(1 - exp(-b*t/a))/t
     - g*(1 - exp(-d*t/c))/t), 
     [bl(not iszero(a)), bl(not iszero(c)), bl(not iszero(f)), bl(not iszero(a*d + b*c))]],

 [ln(e*(a*s+b)^f/(c*s+d)^f), 
     ln(e*a^f/c^f)*dirac(t) + f*2*sinh(b*t/a)/t,
     [bl(not iszero(a)), bl(not iszero(b)), bl(not iszero(c)), bl(not iszero(f)),
      bl(iszero(a*d + b*c)) ]],
 [ln(e*(a+b/s)^f/(c+d/s)^f), 
     ln(e*a^f/c^f)*dirac(t) + f*2*sinh(b*t/a)/t,
     [bl(not iszero(a)), bl(not iszero(b)), bl(not iszero(c)), bl(not iszero(f)),
      bl(iszero(a*d + b*c)) ]],

 [ln(e*(g*(a*s+b)/(c*s+d))^f),
     ln(e*(g*a/c)^f)*dirac(t) + f*2*sinh(b*t/a)/t,
     [bl(not iszero(a)), bl(not iszero(b)), bl(not iszero(c)), bl(not iszero(f)),
      bl(iszero(a*d + b*c))]],
 [ln(e*(g*(a+b/s)/(c+d/s))^f),
     ln(e*(g*a/c)^f)*dirac(t) + f*2*sinh(b*t/a)/t,
     [bl(not iszero(a)), bl(not iszero(b)), bl(not iszero(c)), bl(not iszero(f)),
      bl(iszero(a*d + b*c))]],

 [ln(e*(a*s^2 + b)^f), 
     bl(ln(e*a^f)*dirac(t) + 2*f*transform::frozenInvlaplace(ln(s), s, t) 
      + 2*f*(1 - cos(Wb(b)/Wb(a)*t))/t),  // Wb = specfunc::Wurzelbehandlung
     [bl(not iszero(a)), bl(not iszero(f))]],
 [ln(e*(a + b/s^2)^f), 
     bl(ln(e*a^f)*dirac(t) + 2*f*(1 - cos(Wb(b)/Wb(a)*t))/t),
     [bl(not iszero(a)), bl(not iszero(f))]],
 [ln(e*(a*s^2 + b)^f/(c*s^2 + d)^g), 
     bl(ln(e*a^f/c^g)*dirac(t)
      + 2*(f-g)*transform::frozenInvlaplace(ln(s), s, t) 
      + 2*f*(1 - cos(Wb(b)/Wb(a)*t))/t
      - 2*g*(1 - cos(Wb(d)/Wb(c)*t))/t),
     [bl(not iszero(a)), bl(not iszero(c)), bl(not iszero(f)), bl(not iszero(g)), bl(not iszero(a*d - b*c))]],
 [ln(e*(a + b/s^2)^f/(c + d/s^2)^g), 
     bl(ln(e*a^f/c^g)*dirac(t)
      + 2*f*(1 - cos(Wb(b)/Wb(a)*t))/t
      - 2*g*(1 - cos(Wb(d)/Wb(c)*t))/t),
     [bl(not iszero(a)), bl(not iszero(c)), bl(not iszero(f)), bl(not iszero(g)), bl(not iszero(a*d - b*c))]],
 [ln(e*(g*(a*s^2 + b)/(c*s^2 + d) )^f), 
     bl(ln(e*(g*a/c)^f)*dirac(t)
      + 2*f*cos(Wb(d)/Wb(c)*t)/t
      - 2*f*cos(Wb(b)/Wb(a)*t)/t),
     [bl(not iszero(a)), bl(not iszero(c)), bl(not iszero(f)), bl(not iszero(a*d - b*c))]],
 [ln(e*(g*(a + b/s^2)/(c + d/s^2) )^f), 
     bl(ln(e*(g*a/c)^f)*dirac(t)
      + 2*f*cos(Wb(d)/Wb(c)*t)/t
      - 2*f*cos(Wb(b)/Wb(a)*t)/t),
     [bl(not iszero(a)), bl(not iszero(c)), bl(not iszero(f)), bl(not iszero(a*d - b*c))]],

 [(a*s^2 + b)^c,
     bl(a^c*sqrt(PI)/gamma(-c)*2^(c+1/2)
        /t^(c+1/2)*besselJ(-1/2 - c, Wb(b/a)*t)*Wb(b/a)^(c + 1/2)),
      // exclude c = -1,-2: there are better (more explicit) 
      // formulas in the code of IL_power:
      [bl(not iszero(a)), bl(not iszero((c+1)*(c+2))), Re(c) < 0]],

 [1/sqrt(s^2 + b)/((s^2 + b)^(1/2) + s)^c,
      bl(besselJ(c, Wb(b)*t)/Wb(b)^c), // Wb = specfunc::Wurzelbehandlung
      [bl(not iszero(b))]],

 [exp(a/s)*s^b,
      bl(Wb(-a)^(b+1)/t^((b+1)/2)*besselJ(-b-1, 2*Wb(-a)*sqrt(t))), // Wb = specfunc::Wurzelbehandlung
      [Re(a) < 0, Re(b) < 0]],

 [exp(a/s)*s^b,
      bl(Wb(a)^(b+1)/t^((b+1)/2)*besselI(-b-1, 2*Wb(a)*sqrt(t))), // Wb = specfunc::Wurzelbehandlung
      [Re(a)>= 0, Re(b)< 0]],

 [exp(a/s),
      bl(Wb(-a)/t^(1/2)*besselJ(-1, 2*Wb(-a)*sqrt(t)) + dirac(t)), // Wb = specfunc::Wurzelbehandlung
      [Re(a) < 0]],

 [exp(a/s),
      bl(Wb(a)/t^(1/2)*besselI(-1, 2*Wb(a)*sqrt(t)) + dirac(t)), // Wb = specfunc::Wurzelbehandlung
      [Re(a)>= 0]],

 [exp(b*s)*exp(- b*(s^2 + a)^(1/2)) / (s^2+a)^(1/2),
      bl(besselJ(0, Wb(a*t^2 + 2*a*b*t))), // Wb = specfunc::Wurzelbehandlung
      []],

 [exp(b*s - b*(s^2 + a)^(1/2)) / (s^2+a)^(1/2),
      bl(besselJ(0, Wb(a*t^2 + 2*a*b*t))), // Wb = specfunc::Wurzelbehandlung
      []],

 [exp(b*(s - (s^2 + a)^(1/2))) / (s^2+a)^(1/2),
      bl(besselJ(0, Wb(a*t^2 + 2*a*b*t))), // Wb = specfunc::Wurzelbehandlung
      []],

//=========================================
//=========================================
 null()
]:
