// Globale Annahmen:
// Variable der Originalfunktion: t
// Variable der Transformierten:  s
// a, b, c, ..., v, w, y sind von t unabhngig
// m, n, m0, n0 positiv und ganzzahlig
// m2, n2 positiv, ganzzahlig, gerade
// m1, n1 positiv, ganzzahlig, ungerade
// m3, n3 ganzzahlig
// mp1 = m+1
// m_ = -m, n_ = -n, m0_ = -m0, n0_ = -n0
// fx, gx, f1x, g1x are unrestricted

// Diese Datei wird aus compile_patterns.mu heraus gelesen.

alias(bl=matchlib::block):

laplace_patterns:=
[
 [erf( a/(b*t)^(1/2)), 
    sign(a/sqrt(b))/s - 
    sign(a/sqrt(b))*exp(-2*abs(a/sqrt(b))*sqrt(s))/s, 
    [a/sqrt(b) in R_]],
 [erfc(a/(b*t)^(1/2)), (1 - sign(a/sqrt(b)))/s + 
    sign(a/sqrt(b))*exp(-2*abs(a/sqrt(b))*sqrt(s)) /s, 
    [a/sqrt(b) in R_]],
 [dirac(a*t + b), bl(exp(s*b/a)/abs(a)), [b/a <= 0]],
 [dirac(a*t + b), 0, [b/a > 0]],
 [dirac(a*t + b)*fx, bl(exp(s*b/a)/abs(a)*transform::laplace::evalAtPoint(fx, t, -b/a)), [b/a <= 0]],
 [dirac(a*t + b)*fx, 0, [b/a > 0]],
 [(a*t+b)^c, exp(s*b/a)*a^c*(gamma(1+c)/s^(1+c)+(-gamma(c+1)+igamma(1+c,b/a*s))*(b/a)^(c+1)/(b/a*s)^(1+c)), 
          [a > 0 or b/a >= 0 or c in Z_,  // (a*t + b)^c = a^c*(t+b/a)^c, because t + b/a >= 0
	   Re(c) > -1 or not (b/a <= 0)]  // no singularity t=- b/a or a mild one (Re(c) > -1)
	  ],

 [1/(a*t + b), 
     exp(b/a*s)/a * Ei(1, b/a*s), 
     [b/a > 0]],
 [1/(a*t + b), 
     bl(transform::frozenLaplace(1/t, t, s)/a),
     [b/a = 0]], 
 [1/(a*t + b), 
     exp(b/a*s)/a *(Ei(1, b/a*s) + ln(b/a*s) - ln(s-a) - ln(b/a)/2 + ln(a/b)/2),
     [not b/a >= 0]],

 [exp(c*t + d)/(a*t + b), 
     exp(d)*exp(b/a*(s - c))/a * Ei(1, b/a*(s-c)), 
     [b/a > 0]],
 [exp(c*t + d)/(a*t + b), 
     bl(exp(d)*transform::frozenLaplace(1/t, t, s)/a + exp(d)*ln(s)/a - exp(d)*ln(s - c)/a),
     [b/a = 0]], 
 [exp(c*t + d)/(a*t + b), 
     exp(d)*exp(b/a*(s - c))/a *(Ei(1, b/a*(s-c)) + ln(b/a*(s-c)) - ln(s-c) - ln(b/a)/2 + ln(a/b)/2),
     [not b/a >= 0]],

 [cos(c*t + d)/(a*t + b), 
      1/2/a*exp(-I*b/a*c+I*d+b/a*s) * Ei(1,b/a*(s-I*c))
     +1/2/a*exp(-I*d+I*b/a*c+b/a*s) * Ei(1,b/a*(s+I*c)),
      [b/a > 0]],
 [cos(c*t + d)/(a*t + b), 
       cos(d)/a*transform::frozenLaplace(1/t, t, s) 
     - cos(d)/a*ln(1 + c^2/s^2)/2 
     - sin(d)/a*arctan(c/s),
      [b/a = 0]],
 [cos(c*t + d)/(a*t + b), 
      1/2/a*exp(-I*b/a*c+I*d+b/a*s) * (Ei(1,b/a*(s-I*c))+ln(a/b)/2-ln(b/a)/2-ln(s-I*c)+ln(b/a*(s-I*c)))
     +1/2/a*exp(-I*d+I*b/a*c+b/a*s) * (Ei(1,b/a*(s+I*c))+ln(a/b)/2-ln(b/a)/2-ln(s+I*c)+ln(b/a*(s+I*c))),
      [not b/a >= 0]],

 [sin(c*t + d)/(a*t + b),
      I/2/a*exp(-I*d+I*b/a*c+b/a*s) * Ei(1,b/a*(s+I*c))
     -I/2/a*exp(-I*b/a*c+I*d+b/a*s) * Ei(1,b/a*(s-I*c)),
      [b/a > 0]],
 [sin(c*t + d)/(a*t + b),
       +sin(d)/a*transform::frozenLaplace(1/t,t,s)
       +cos(d)/a *arctan(c/s)
       -sin(d)*ln(1+c^2/s^2)/2/a,
      [b/a = 0]],
 [sin(c*t + d)/(a*t + b),
      I/2/a*exp(-I*d+I*b/a*c+b/a*s) * (Ei(1,b/a*(s+I*c))+ln(a/b)/2-ln(b/a)/2-ln(s+I*c)+ln(b/a*(s+I*c)))
     -I/2/a*exp(-I*b/a*c+I*d+b/a*s) * (Ei(1,b/a*(s-I*c))+ln(a/b)/2-ln(b/a)/2-ln(s-I*c)+ln(b/a*(s-I*c))),
      [not b/a >= 0]],

 null()
]:
