/* 
   tests if an expression is linear in the indeterminates in l,
   returns the list of coefficients or FALSE:

   transform::TypeLinear(a*x+b,[x]) -> [a,b]
   transform::TypeLinear(a*x+b*y+c,[x,y]) -> [a,b,c]
   transform::TypeLinear(a*x^2+b*y+c,[x,y]) -> FALSE

   This is a modified copy of Type::Linear.
   When modifying Type::Linear, there are many crashes in the
   testfiles for solve, int, ode, simplify. Since presently 
   there is no time to debug these, I do my own thing by
   implementing transform::Type::Linear and calling it from
   inside transform.
*/

transform::TypeLinear:=proc(p,l)
  option noDebug;
  local t, m, f, a, i, d, n, nonlinear;
begin
      n:=nops(l);
    
      if not has(p, l) then
        return([0 $ n, p])
      end_if;

      nonlinear:= FALSE;
      // Do not expand in TypeLinear((x + 1)^1234567, [x]) !!
      // Either the base does not depend on the variables 
      // or the expression is non-linear.
      misc::maprec(p, {"_power"} =
          proc(x) begin
             if has(op(x, 1), l) and
               (
                domtype(op(x, 2)) <> DOM_INT or
                (type(op(x, 1)) = "_plus" and
                 op(x, 2) > 100)
               ) then
                nonlinear:= TRUE;
                misc::breakmap;
             end_if;
             x;
          end_proc);
      if nonlinear then 
         return(FALSE);
      end_if;

      // Beware: do not use poly to do the expansion! Note
      // that poly((a*x^2 + b+x)/x, [x]) produces FAIL!
      p:= expand(p, ArithmeticOnly); 

      if type(p) <> "_plus" then 
         p:= [p] 
      end_if;

      m:=[0$n+1];
      for t in p do
         if type(t)<>"_mult" then t:=[t] end_if;
         a:=1; d:=0;
         for f in t do
            if type(f)="_power" then 
               if contains(l, op(f, 1))<>0 then 
                  return(FALSE)
               elif has(f,l) then 
                  return(FALSE)
               else 
                  a:=a*f
               end_if
            elif (i:=contains(l,f))<>0 then // f is one of the variables 
               if d=0 then d:=i else return(FALSE) end_if
            elif has(f,l) then return(FALSE) // f=cos(x) for example 
            else a:=a*f
            end_if;
         end_for;
         if d=0 then 
            d:=n+1 
         end_if;
         m[d]:= m[d] + a;
      end_for;
      return(m);
end_proc:
