

alias(bl=matchlib::block):

transform::ztrans::addpattern :=
proc(pattern, varin, varout, result, pat_vars, conds)
  option hold;
  save _X, _Y;
begin
  pattern := context(pattern);
  varin := context(varin);
  varout := context(varout);
  result := context(hold(bl)(result));
  if args(0) > 4 then
    pat_vars := context(pat_vars);
  else
    pat_vars := [];
  end_if;
  if args(0) > 5 then
    conds := context(hold(map)(hold(hold)(conds), bl));
  else
    conds := [];
  end;
  if domtype(conds) <> DOM_LIST then conds := [conds]; end_if;

  if varin = varout then
    error("Can't handle identical inout/output variables");
  end_if;

  //-----------------------------------------------
  // Walter, 28.2.06:
  // Clear the remember table of transform::ztrans
  // (Otherwise the new pattern will not be active,
  //  if a symbolic transform::ztrans is in the
  //  remember table of transform::ztrans.)
  transform::ztrans(Remember, Clear):
  //-----------------------------------------------

  unprotect(_X);
  unprotect(_Y);
  delete _X, _Y;

  if varout <> _Y and has([pattern, result, pat_vars, varin, conds], _Y) then
    [pattern, result, pat_vars, varin, conds] := 
      subs([pattern, result, pat_vars, varin, conds], _Y=genident("_Y"));
  end;
  [pattern, result, pat_vars, varin, conds] :=
    subs([pattern, result, pat_vars, varin, conds], varout = _Y);
    
  if varin <> _X and has([pattern, result, pat_vars, varout, conds], _X) then
    [pattern, result, pat_vars, varout, conds] := 
      subs([pattern, result, pat_vars, varout, conds], _X=genident("_X"));
  end;
  [pattern, result, pat_vars, conds] :=
    subs([pattern, result, pat_vars, conds], varin = _X);


  matchlib::addpatterns(transform::ztrans::userpatternsFSA,
                        transform::ztrans::userpatterns,
	                    [[pattern, result, pat_vars, conds,
	                      map(pat_vars, v -> subs(bl(not has(`#v`, _X)), `#v`=v))]],
	                    transform::ztrans::addpattern::generalizesum, FALSE, FAIL);

  null();
end:

transform::ztrans::addpattern := funcenv(transform::ztrans::addpattern):

// for patterns matching a _plus expression, add `#hx`
// to the pattern and transform::ztrans(`#hx`, t, z) to the result:
transform::ztrans::addpattern::generalizesum :=
p -> ((if type(p[1])="_plus" then
			    [p[1]+`##`(`#hx`),
                             (bl@(x->x))
			     (hold(_plus)(matchlib::unblock(p[2]),
                                          hold(transform::ztrans(`#hx`, k, z))))
			    ].p[3..-1]
			  else p end_if)):
transform::ztrans::addpattern::generalizesum := id:

