//alias(invztrans = transform::invztrans):
//invztrans:=newDomain("invztrans"):
//invztrans::create_dom:=hold(transform::invztrans):
//invztrans::Name:="transform::invztrans":

//-----------------------------------------------
transform::invztrans:=
proc(f, z, k)
  name transform::invztrans ;
  local rationalCase, ff, gg, constants, dummy, 
        a, trans, C, pos, kk, p, monom, r, mycollect;
  save _X, _Y;
begin
  if args(0) = 0 then
     error("no arguments"):
  end_if;
  if f::dom = Factored then
     f:= expr(f);
  end_if;
  if f::dom::invztrans <> FAIL then
     return(f::dom::invztrans(args())):
  end_if;
  if args(0) <> 3 then
     error("expecting 3 arguments"):
  end_if;
  if domtype(z) <> DOM_IDENT and
     type(z) <> "_index" then
        error("2nd argument: expecting an identifier ".
              "or an indexed identifier");
  end_if;
  //-----------------------------------
  // special case f = const (for speed)
  //-----------------------------------
  if not has(f, z) then
     return(f*kroneckerDelta(k, 0));
  end_if;
  //-----------------------------------
  // special cases z^d (for speed)
  //-----------------------------------
  if f = z or 
     type(f) = "_power" and
        op(f, 2) = z and
        domtype(op(f, 2)) = DOM_INT and
        op(f, 2) > 0 then
     return(hold(transform::invztrans)(f, z, k));
  end_if;
  //---------------------------
  // partial fraction expansion
  //---------------------------
  rationalCase:= FALSE;
  if traperror(poly(1, [z])) = 0 
     // otherwise partfrac produces: error("illegal indeterminate")
     and 
     testtype(f, Type::RatExpr(z) ) 
     // otherwise partfrac produces: error("not a rational function")
     then
      rationalCase:= TRUE;
      // Walter: 5.4.08 (reaction to changes in partfrac):
      // partfrac((x^2 + a*x + b)/(x^2 + c*x + d), x) produces
      // 1 + (b - d + a*x - c*x)/(x^2 + c*x + d). The matcher
      // has patterns for (A*x + B)/(x^2 + C*x + D), but does 
      // not match a*x-c*x to A*x. We need to collect terms!
      mycollect:= proc(a)
                  begin
                    if not has(a, z) then
                       return(a)
                    end_if:
                    if type(a) = "_power" and 
                       not has(op(a, 2), z) then
                       return(mycollect(op(a, 1))^op(a, 2));
                    elif type(a) = "_mult" then
                       // do not loose factorizations, so map
                       // into the factors instead of collecting
                       // the terms of the polynomial
                       return(map(a, mycollect));
                    elif type(a) = "_plus" then
                       return(eval(collect(a, [z])));
                    end_if:
                    return(a);
                  end_proc:
      f:= partfrac(f, z, Mapcoeffs = mycollect);
  end_if:
  //-----------------------------------
  // linearity
  //-----------------------------------
  if (not rationalCase) then
     // Expand f without using expand (stuff like 
     // exp, sin, cos, fact etc should not be expanded).
     f:= transform::expand(f, z):
  end_if;
  if type(f) = "_plus" then
     return(map(f, transform::invztrans, z, k));
  end_if;
  if type(f) = "_mult" then
     // extract constants
     [ff, constants, dummy]:= split(f, has, z);
     if ff <> f and not iszero(constants -1) then
        return(constants*transform::invztrans(ff, z, k));
     end_if;
  end_if;
  if type(f) = "transform::ztrans" then
     return(transform::ztrans::invztrans(args()));
  end_if:
  //-----------------------------------
  // implement 
  //    invztrans((-z*d/dz)^m(f(z),z), z, k)
  //  = k^m* invztrans(f(z), z, k)
  //-----------------------------------
  if hastype(f, "diff") then
     if type(f) = "_mult" then
        [ff, a, dummy]:= split(f, ff -> type(ff) = "diff");
     else
        [ff, a]:= [f, 1]:
     end_if;
     // if ff = diff(g(..), z1, z, z2) etc, find out that
     // there is a differentiation w.r.t. z at the position pos:
     if type(ff) = "diff" and
        (pos:= contains([op(ff, 2..nops(ff))], z)) > 0
        then
           if nops(ff) = 2 then
              ff:= op(ff, 1):
           else
              ff:= subsop(ff, pos + 1 = null());
           end_if;
           // now, f = a(z)*diff(ff(z), z)
           // = z*diff( a(z)/z*ff(z) , z)
           //   + (a(z)/z - diff(a(z),z))*ff(z)
           // invztrans of the first term yields
           // -k * invztrans(a/z*ff, z, k);
           return(transform::invztrans(normal((1 - k)*a/z - diff(a, z))*ff, z, k));
     end_if;
  end_if;
  //-------------------------
  // Prepare for the lookup (need the
  // correct pattern variable)
  //-------------------------
  C:=genident() ;
  delete _X, _Y;
  if z <> _X then
    f:= subs(f,[_X=C, z=_X],EvalChanges);
  end_if;
  //-------------------------
  // Try the lookup mechanism
  //-------------------------
  userinfo(2,"trying the lookup method for invztrans");
  trans:= transform::invztrans::lookup(f, _X);
  if trans<>FAIL then
    trans:= subs(trans, [_X=z, _Y=k, C=_X], EvalChanges) ;
    return(trans);
  end_if;
  //----------------------------------
  // invztrans of rational expressions
  //----------------------------------
  if rationalCase then
     trans:= transform::invztrans::rational(f, _X, k):
     if trans<>FAIL then
       trans:= subs(trans, [_X=z, C=_X], EvalChanges) ;
       return(trans);
     end_if;
  end_if;
  //----------------------------------------------
  // restore original variables
  //----------------------------------------------
  f:= subs(f, [_X=z, C=_X]) ;
  //-----------------------------------------------------------------
  // reduce the first argument according to the rule:
  // invztrans(z^a*f(z), z, z) 
  //  = invztrans(f(z), z, k + a)
  //    - sum(invztrans(f(z), z, r)*kroneckerDelta(k, r-1), r = 1.. a - 1)
  //-----------------------------------------------------------------
  if type(f) = "_mult" then
     [p, ff, dummy]:= split(f, x -> testtype(x, Type::PolyExpr(z)));
     if not iszero(p - 1) then
        kk:= genident("k");
        gg:= transform::invztrans(ff, z, kk);
        if type(gg) <> "transform::invztrans" then
           trans:= 0:
           for monom in poly2list(p, [z]) do
              trans:= trans 
                      + monom[1]*subs(gg, kk = k + monom[2],EvalChanges)
                      + monom[1]*_plus(subs(gg, kk = r, EvalChanges)
                                       *transform::invztrans(z^(monom[2] - r), z, k) 
                                       $ r = 0..monom[2] - 1) ;
           end_for:
           if trans <> FAIL then
              return(trans);
           end_if;
        end_if;
     end_if;
  end_if;
  //----------------------------------------------
  // final return
  //----------------------------------------------
  return(hold(transform::invztrans)(f, z, k));
end:

transform::invztrans:= funcenv(transform::invztrans):
transform::invztrans:= prog::remember(transform::invztrans, property::depends):
transform::invztrans::type:= "transform::invztrans":
transform::invztrans::interface := {hold(addpattern)}:
//-------------------------------------
// invztrans::rational(f(z), z, k)
// computes invztrans for rational expressions
// f(z) = numer(z)/denom(z)
// Note that f(z) is not a sum, because this procedure
// is mapped to the terms of a partfrac expansion.
//-------------------------------------
transform::invztrans::rational:= proc(f, z, k)
local p, q, dq, coeffs, dummy, c, 
      r, roots, _z, q_z, qq, res, trans;
begin
   // The rational function is a term of a partial
   // fraction expansion with constant coefficients
   // removed:

   if not has(f, z) then 
      return(f*kroneckerDelta(k, 0));
   end_if;

   // f:= p/q with polynomials p = p(z), q = q(z)
   [p, q]:= [numer(f), denom(f)];

   if degree(p, [z]) >= degree(q, [z]) then
      return(FAIL);
   end_if;

   // -----------------------------------------
   // move constant factors from denominator q
   // to the numerator p:
   // -----------------------------------------
   coeffs:= 1:
   if type(q) = "_mult" then
      [q, coeffs, dummy]:= split(q, has, z);
      p:= p/coeffs;
   end_if;

   // -----------------------------------------
   // turn denominator into the form (irreducible)^dq
   // -----------------------------------------
   if type(q) =  "_power" then
      [q, dq]:= [op(q)];
      // original_q = q^dq with some
      // **irreducible** polynomial q.
   else
      dq:= 1:
   end_if;

   assert(type(q) <> "_mult"):
   assert(type(q) <> "_power"):
   assert(irreducible(q));

   //-------------------------------------------------------
   // Result so far: f = p(z)/q(z)^dq  with irreducible q(z)
   //-------------------------------------------------------

   //--------------------------------------
   // We have to compute the residues
   // diff( z^(k-1) * p(z)/ (q(z)/(z -r))^dq , z $ dq - 1)
   // at the point z = r, where r are the roots of q(z).
   //--------------------------------------
   // Represent the roots: either explicit 
   // (for degree(q) = 1, 2) or as RootOf:
   //--------------------------------------
   case degree(q, [z]) 
   of 0 do 
       return(FAIL); // error("should not arrive here");
   of 1 do
       c[0]:= coeff(q, [z], 0);
       c[1]:= coeff(q, [z], 1);
       roots:= {-c[0]/c[1]};
       break;
   of 2 do
       c[0]:= coeff(q, [z], 0);
       c[1]:= coeff(q, [z], 1);
       c[2]:= coeff(q, [z], 2);
       roots:= {
                 (-c[1] + sqrt(c[1]^2 - 4*c[0]*c[2]))/(2*c[2]),
                 (-c[1] - sqrt(c[1]^2 - 4*c[0]*c[2]))/(2*c[2])
               };
       break;
   otherwise
       _z:= genident("z"):
       q_z:= subs(q, z = _z):
       roots:= RootOf(subs(q, z = _z), _z)
   end_case;

   //--------------------------------------------
   // compute qq = q(z)/(z - r) assuming q(r) = 0
   //--------------------------------------------
   qq:= (q, z, r) -> divide(q, z - r, [z])[1]:

   /* --------------------------------------------------------
   //-------------------------------------------
   // compute the residue of z^(k-1)*p(z)/qq(z) =
   //  1/(dq-1)!*diff(z^(k-1)*p(z)/qq(z)^d, z$dq -1)
   // at the point z = r
   // We compute this either by brute force
   // differentiating the rational expression
   // or by 'automatic' differentiation:
   //-------------------------------------------
   // Remark: We may compute
   //   Dq[j][i + 1] = diff( (q(z)/(z - r))^j, z $ i) | z = r
   // via automatic differentiation using the recursion 
   //  diff(qq^j, x $ i) = 
   //   _plus(binomial(i, k) *diff(qq^(j-1), z $ kk)
   //        *diff(qq, z $ kk - i), kk = 0..i);
   Dq:= [[ 0 $ d] $ d]:
   Dq[1]:= subs([diff(q(z), z $ i + 1)/(i + 1) $ i = 0..d-1], z = r);
   for j from 2 to d do
    Dq[j][1]:= Dq[1][1]^j;
    for i from 1 to d-1  do
       Dq[j][i + 1]:= _plus(binomial(i, kk)*Dq[j-1][kk+1]*Dq[1][i - kk + 1] $ kk = 0..i);  
    end_for:
   end_for:
   // We compute
   //   L[i + 1] = diff( ((z - r)/q(z))^d, z $ i) | z = r
   // via automatic differentiation using the recursion 
   //  diff(p(z)/qq(z), x $ i) = 
   //   diff(p(z), x $ i)/qq(z) -
   //    _plus(binomial(i, kk)*diff(p(z)/qq(z), z $ kk) / qq(z)
   //          * diff(qq(z), z $ i-kk), kk = 0.. i-1))
   // with p(z) = 1 and qq(z) = (q(z)/(z -r))^j
   //-------------------------------------------------------
   q0:= (q'(r))^d:
   pp:= subs([diff(z^(k -1)*p(z), z $ i) $ i = 0..d], z = r); 
   L:= [r^(k-1)*p(r)/q'(r)^d, 0 $ d-1]:
   for i from 1 to d-1 do
      L[i+1]:= pp[i+1]/q0 -_plus(binomial(i, kk)* L[kk+1]/q0 * Dq[d][i-kk+1] $ kk = 0..i-1);
   end_for:
   res:= L[d]:  // the residue
   //-------------------------------------------------------
   */

   //-------------------------------------------
   // compute the residue of z^(k-1)*p(z)/qq(z) =
   //  1/(dq-1)!*diff(z^(k-1)*p(z)/qq(z)^d, z$dq -1)
   // at the point z = r by direct differentiation
   //-------------------------------------------

   if domtype(roots) = DOM_SET then
     trans:= 0:
     for r in roots do
       res:= z^(k-1)*p/qq(q, z, r)^dq;
       res:= diff(res, z $ dq - 1):
       res:= subs(res, z = r):
       trans:= trans +  res/(dq - 1)!;
     end_for:
   else
      assert(type(roots) = RootOf); 
      r:= genident("r"):
      res:= z^(k-1)*p/qq(q, z, r)^dq;
      res:= subs(diff(res, z $ dq - 1), r = z, EvalChanges):
      res:= subs(res, z = r):

      /* 
      // convert 1/denom(t) mod q(r) to a polynomial?
      den:= [gcdex(denom(res), subs(q, z = r), r)];
      assert(den[1] = 1): // q is irreducible!
      res:= divide(numer(res)*den[2], subs(q, z = r), [r])[2];
      */

      //-------------------------------------------
      // res is a rational expression in r. Reduce
      // numerator and denominator modulo q(r) = 0:
      //-------------------------------------------
      res:= divide(numer(res), subs(q, z = r), [r])[2] /
            divide(denom(res), subs(q, z = r), [r])[2];
      
      if domtype(k) = DOM_INT and k >= 0 then
         trans:= sum(res/(dq -1)! , r in roots):
      else
         trans:= hold(sum)(res/(dq -1)! , r in roots):
      end_if;
   end_if;
   return(trans + kroneckerDelta(k, 0)*subs(f, z = 0, EvalChanges));
end_proc:

//-------------------------------------
//transform::invztrans::print:= proc(T)
//begin
//  hold(transform::invztrans)(extop(T,1), extop(T,2), extop(T,3));
//end_proc:
//-------------------------------------
transform::invztrans::has:=proc(x, v)
begin
  bool( has(extop(x,1), v) or
        has(extop(x,2), v) or
        has(extop(x,3), v) or
        v=hold(transform::invztrans))
end_proc:
//-------------------------------------
transform::invztrans::evaluate:= proc(x) begin
    if eval(op(x, 1)) <> op(x, 1) then
       transform::invztrans(eval(op(x, 1)), op(x, 2), op(x, 3)):
    else
       x;
    end_if;
end_proc:
//-------------------------------------
// Necessary for the subs command after the lookup mechnism, because
// otherwise no further evaluation is done for substituted elements in a
// transform::invztrans element

// transform::invztrans::subs:= e -> new(dom, subs(extop(e), args(2..args(0)))):
//-------------------------------------
/* This will not work, since map(transform::invztrans(something(z),z,k), f)
 will not call transform::invztrans::map

transform::invztrans::map:= 
  proc(x, f) begin
    transform::invztrans(map(op(x, 1), args(2..args(0))), op(x, 2), op(x, 3)):
  end_proc:
*/
//-------------------------------------
// ztrans(invztrans(f(x), x, k), k, z)
transform::invztrans::ztrans:= proc(f, k, z)
local k0, r;
begin
     // f = invztrans(f(x), x, k)
     if args(0) <> 3 then
        error("expecting 3 arguments"):
     end_if;
     if extop(f, 3) = k then
        return(subs(extop(f,1), extop(f,2) = z, EvalChanges))
     end_if;
     //   ztrans(invztrans(f(x), x, k + k0), k, z)
     // = ztrans(invztrans(x^k0*f(x), x, k) + poly, k, z)
     // = z^k0*f(z) + ...
     // The following lines copy the corresponding code
     // in ztrans. Keep these parts synchronized! 
     k0 := extop(f, 3) - k;
     if not has(k0, k) and domtype(k0) = DOM_INT
        and specfunc::abs(k0) < 1000 then
        if k0 > 0 then
           return( subs(z^k0*extop(f,1), extop(f,2)=z, EvalChanges)
                  - _plus(z^(k0 - r)*subs(f, extop(f, 3) = r) $ r = 0..k0 - 1)
                 );
        elif k0 < 0 then
           return( subs(z^k0*extop(f,1), extop(f,2)=z, EvalChanges)
                  + _plus(z^(k0 - r)*subs(f, k = r, EvalChanges) $ r = k0 .. - 1));
        end_if;
     end_if;
     hold(transform::ztrans)(f, k, z):
end_proc:
//-------------------------------------
transform::invztrans::float:= () -> 
    transform::invztrans(float(args(1)), args(2), args(3)):
//-------------------------------------
transform::invztrans::numer:= id:
transform::invztrans::denom:= 0:
//-------------------------------------
/* This will not work, since normal(transform::invztrans(something(z),z,k))
 will not call transform::invztrans::normal
transform::invztrans::normal:= proc(x)
local nf;
begin
     nf:= normal(op(x, 1)):
     if nf <> op(x, 1) then
        transform::invztrans(nf, op(x, 2), op(x, 3));
     else
        x;
     end_if;
end_proc:
//-------------------------------------
*/

//------------------------------------------------
// overloading of evalAt is needed for testeq etc.
// Ignore substitutions of the second operand!
//------------------------------------------------
transform::invztrans::evalAt:= proc(f, subst)
local g, z, zz, k, kk;
begin
   assert(type(f) = "transform::invztrans");
   [g, z, k]:= [extop(f)];
   // ignore substitutions of the bound variable z:
   subst:= select(subst, y -> (op(y, 1) <> z) );
   // when the bound variable z is in the rhs's of the
   // substitutions, change the name of the variable:
   if contains(freeIndets(map(subst, op, 2)), z) then
      zz:= genident(expr2text(z));
      f:= subs(f, z = zz);
      g:= subs(g, z = zz);
      z:= zz;
   end_if;
   g:= g | subst;
   kk:= k | subst;
   if extop(f, 1) <> g or k <> kk then
      return(transform::invztrans(g, z, kk))
   else
      return(f)
   end_if;
end_proc:

//------------------------------------------------

transform::invztrans::freeIndets:= proc(f)
begin
  assert(type(f) = "transform::invztrans");
  freeIndets([extop(f, 1), extop(f, 3)], args(2..args(0))) minus {extop(f, 2)};
end_proc:

//------------------------------------------------

alias(path = pathname("TRANS","ZTRANS")):
transform::invztrans::lookup:=
        loadproc( transform::invztrans::lookup,        path, "invlookup"     ):
transform::invztrans::patterns:=
        loadproc( transform::invztrans::patterns,    path, "load_patterns" ):
transform::invztrans::addpattern:=
        loadproc( transform::invztrans::addpattern,    path, "invaddpattern" ):

transform::invztrans::userpatterns := []:
transform::invztrans::userpatternsFSA := FAIL:
