//alias(ztrans = transform::ztrans):
//ztrans:=newDomain("ztrans"):
//ztrans::create_dom:=hold(transform::ztrans):
//ztrans::Name:="transform::ztrans":

//-------------------------------------
transform::ztrans:= proc(f, k, z)
  name transform::ztrans ;
  local constants, dummy, ff, arguments, 
        k0, K0, r, trans, C;
  save _X, _Y ;
begin
  if args(0) = 0 then
     error("no arguments");
  end_if;
  if f::dom = Factored then
     f:= expr(f);
  end_if;
  if f::dom::ztrans <> FAIL then
     return(f::dom::ztrans(args())):
  end_if;
  if type(f) = "sum" or 
     op(f, 0) = hold(numeric::sum) then
     return(sum(transform::ztrans(op(f, 1), args(2..args(0))), op(f, 2..nops(f)))); 
  end_if;
  if args(0) <> 3 then
     error("expecting 3 arguments"):
  end_if;
  if domtype(k) <> DOM_IDENT and
     type(k) <> "_index" then
        error("2nd argument: expecting an identifier ".
              "or an indexed identifier");
  end_if;
  //-----------------------------------
  // special case f = const (for speed)
  //-----------------------------------
  if not has(f, k) then
     return(f*z/(z - 1));
  end_if;
  //-----------------------------------
  // special case kroneckerDelta: the patterns
  // contain only func(k)*kroneckerDelta(a*k + b, 0).
  // Make sure that kroneckerDelta(a*k + b , c*k + d)
  // are rewritten as kroneckerDelta((a - c)*k + b, 0)
  // matching this pattern
  //-----------------------------------
  if has(f, kroneckerDelta) then
     f:= subs(f, hold(kroneckerDelta) = proc(a, b) 
                      begin
                        kroneckerDelta(collect(a - b, [k]), 0)
                 end_proc, EvalChanges):
  end_if;
  //-----------------------------------
  //-----------------------------------
  // linearity
  //-----------------------------------
  // Expand f without using expand (stuff like
  // exp, sin, cos, fact etc should not be expanded).
  f:= transform::expand(f, k):
  if not has(f, k) then
     return(f*z/(z - 1));
  end_if;
  if type(f) = "_plus" then
     return(map(f, transform::ztrans, k, z));
  end_if;
  if type(f) = "_mult" then
     // extract constants
     [ff, constants, dummy]:= split(f, has, k);
     if ff <> f and not iszero(constants -1) then
        return(constants*transform::ztrans(ff, k, z));
     end_if;
  end_if;
  if type(f) = "transform::invztrans" then
     return(transform::invztrans::ztrans(args()));
  end_if:
  //-----------------------------------------------------------------
  // shift the first argument according to the rule:
  // (with k0 > 0):
  // ztrans(f(k + k0), k, z) = z^k0*ztrans(f(k), k, z) 
  //                         - sum(z^(k0 -r)*f(r), r = 0..k0 - 1)
  // ztrans(f(k - k0), k, z) = z^(-k0)*ztrans(f(k), k, z) 
  //                         + sum(z^(-r)*f(-k0 + r), r = 0..k0 - 1)
  //                         = z^(-k0)*ztrans(f(k), k, z) 
  //                         + sum(z^(-k0 -r)*f(r), r = -k0 .. - 1)
  //-----------------------------------------------------------------
  arguments:= {}:
  misc::maprec(f, (f -> testtype(f, "function"))
                  = proc(f) local x; begin 
                     arguments:= arguments union {(x - k) $ x in [op(f)]}:
                    end_proc):
  if map(arguments, domtype) = {DOM_INT} then
     K0:= min(map(arguments, specfunc::abs));
     k0:= select(arguments, k -> (specfunc::abs(k) = K0));
     if nops(k0) > 1 then
        k0:= select(k0, k -> k > 0);
     end_if;
     k0:= op(k0, 1); // pick the single element from the set k0
     if K0 > 0 and -1000 < k0 and k0 < 1000 then
        f:= subs(f, k = k - k0, EvalChanges):
        if k0 > 0 then
          return(z^k0*transform::ztrans(f, k, z) 
                 -_plus(z^(k0 - r)*subs(f, k = r, EvalChanges) $ r = 0..k0 - 1));
        elif k0 < 0 then
           return(z^k0*transform::ztrans(f, k, z) 
          + _plus(z^(k0 - r)*subs(f, k = r, EvalChanges) $ r = k0 .. - 1));
        else // k0 = 0
           error("should not happen");
        end_if;
     end_if;
  end_if;
  //-------------------------
  // Prepare for the lookup (need the 
  // correct pattern variable)
  //-------------------------
  C:=genident() ;
  delete _X, _Y;
  if k <> _X then
    f:= subs(f,[_X=C, k=_X]);
  end_if;
  //-------------------------
  // Try the lookup mechanism 
  //-------------------------
  userinfo(2,"trying the lookup method for ztrans");
  trans:= transform::ztrans::lookup(f, _X);
  if trans<>FAIL then
    trans:= subs(trans, [_X=k, _Y=z, C=_X], EvalChanges);
    return(trans);
  end_if;
  //----------------------------------------------
  // Shall we try sum(f/z^k, k = 0..infinity) or
  // just give up? (Trying sum may be very expensive)
  // --> use the undocumented option "LookupOnly")
  // Do not pass indexed identifiers to sum!
  // Do use the summation variable _X!
  //----------------------------------------------
  trans:= sum(f/z^_X, _X = 0..infinity, "LookupOnly"):
  if (not hastype(trans, "sum"))  and
     op(trans, 0) <> hold(numeric::sum) then
     trans:= subs(trans, [_X=k, _Y=z, C=_X]) ;
     return(trans);
  end_if;
  //----------------------------------------------
  // restore original variables
  f:= subs(f, [_X=k, C=_X]) ;
  return(hold(transform::ztrans)(f, k, z));
end:

transform::ztrans:= funcenv(transform::ztrans):
transform::ztrans:= prog::remember(transform::ztrans, property::depends):
transform::ztrans::type:= "transform::ztrans":
transform::ztrans::interface := {hold(addpattern)}:
//-------------------------------------
// transform::ztrans::print:= proc(T)
// begin
//   hold(transform::ztrans)(extop(T,1), extop(T,2), extop(T,3));
// end_proc:
//-------------------------------------
transform::ztrans::has:=proc(x, v) 
begin
  bool( has(extop(x,1), v) or
        has(extop(x,2), v) or
        has(extop(x,3), v) or
        v=hold(transform::ztrans))
end_proc:
//-------------------------------------
transform::ztrans::evaluate:= proc(x) begin
    if eval(op(x, 1)) <> op(x, 1) then
       transform::ztrans(eval(op(x, 1)), op(x, 2), op(x, 3)): 
    else
       x;
    end_if;
end_proc:
//-------------------------------------
// Necessary for the subs command after the lookup mechnism, because
// otherwise no further evaluation is done for substituted elements in a
// transform::ztrans element

// transform::ztrans::subs:= e -> new(dom, subs(extop(e), args(2..args(0)))):
//-------------------------------------
/* This will not work, since map(transform::ztrans(something(k),k,z), f)
 will not call transform::ztrans::map 
transform::ztrans::map:= 
proc(x, f) begin
   transform::ztrans(map(op(x, 1), args(2..args(0))), op(x, 2), op(x, 3)): 
end_proc:
*/
//-------------------------------------
// invztrans(ztrans(f(n), n, z), z, k)
transform::ztrans::invztrans:= proc(f, z, k)
local c;
begin
     if extop(f, 3) = k then
        return(subs(extop(f,1), extop(f,2) = k, EvalChanges))
     end_if;
     //   invztrans(ztrans(f(n), n, c*z), z, k)
     // = invztrans(ztrans(f(n)/c^n, n, z), z, k)
     // =  f(n)/c^n
     c := extop(f, 3)/z;
     if (not has(c, z)) and (not iszero(c)) then
        return(subs(extop(f,1), extop(f,2) = k, EvalChanges)*(1/c)^k)
     end_if;
     hold(transform::invztrans)(f, z, k):
end_proc:
//-------------------------------------
transform::ztrans::diff:= proc(f, x)
local g, n, z;
begin
  if args(0) = 1 then 
     return(args(1));
  end_if;
  if args(0) > 2 then
     return(diff(transform::ztrans::diff(f, x), args(3..args(0))));
  end_if;
  // take apart f = transform::ztransform(g(n, x), n, z(x))
  [g, n, z]:= [op(f)]:
  if x = n then
     return(0)
  end_if:
  if x = z then
     return(hold(diff)(f, x));
  end_if:
  if domtype(x) <> DOM_IDENT then
     return(hold(diff)(f, x));
  end_if;
  if not has(z, x) then
     return(transform::ztrans(diff(g, x), n, z))
  elif not has(g, x) then
     return(-hold(transform::ztrans)(n*g, n, z)/z*diff(z, x))
  else
     return(transform::ztrans(diff(g, x), n, z) - hold(transform::ztrans)(n*g, n, z)/z*diff(z, x));
  end_if;
end_proc:
//-------------------------------------
transform::ztrans::float:= x -> 
   transform::ztrans(float(args(1)), args(2), args(3)):
//-------------------------------------
transform::ztrans::numer:= id:
transform::ztrans::denom:= 0:
//-------------------------------------
/* This will not work, since normal(transform::ztrans(something(k),k,z))
 will not call transform::ztrans::normal 
transform::ztrans::normal:= proc(x) 
local nf;
begin
     nf:= normal(op(x, 1)):
     if nf <> op(x, 1) then
        transform::ztrans(nf, op(x, 2), op(x, 3));
     else
        x;
     end_if;
end_proc:
*/
//-------------------------------------
//-------------------------------------
//-------------------------------------

//-------------------------------------
// utility for 
// ztrans(k^m*f(k), k, z) = (-z*d/dz)^m *ztrans(f(k),k,z).
// mult2diff(ztrans(f(k),k,z), z, n) = -
//-------------------------------------
transform::ztrans::mult2diff:= proc(f, z, n)
  local i, _z ;
begin
   if f = FAIL then 
      return(FAIL);
   end_if;
   if type(z) = DOM_IDENT then
      _z := z;
   else
      _z:= genident("z"):
   end_if;
   f:= subs(f, z = _z);
   for i from 1 to n do
       f:= normal(-_z*diff(f, _z)):
   end_for;
   if _z <> z then
      f:= subs(f, _z = z);
   end_if;
   return(f);
end_proc:

//-------------------------------------
// utility for 
// ztrans(f(k)*kroneckerDelta(k,k0), k, z) = subs(f(k), k = k0)
//-------------------------------------
transform::ztrans::evalAtPoint:= (f, k, k0) -> subs(f, k = k0, EvalChanges):

//------------------------------------------------
// overloading of evalAt is needed for testeq etc.
// Ignore substitutions of the second operand!
//------------------------------------------------
transform::ztrans::evalAt:= proc(f, subst)
local g, k, kk, z, zz;
begin
   assert(type(f) = "transform::ztrans");
   [g, k, z]:= [extop(f)];
   // ignore substitutions of the bound variable k:
   subst:= select(subst, y -> (op(y, 1) <> k) );
   // when the bound variable k is in the rhs's of the
   // substitutions, change the name of the variable:
   if contains(freeIndets(map(subst, op, 2)), k) then
      kk:= genident(expr2text(k));
      f:= subs(f, k = kk);
      g:= subs(g, k = kk);
      k:= kk;
   end_if;
   g:= g | subst;
   zz:= z | subst;
   if extop(f, 1) <> g or z <> zz then
      return(transform::ztrans(g, k, zz))
   else
      return(f)
   end_if;
end_proc:
//------------------------------------------------

transform::ztrans::freeIndets:= proc(f)
begin
  assert(type(f) = "transform::ztrans");
  freeIndets([extop(f, 1), extop(f, 3)], args(2..args(0))) minus {extop(f, 2)};
end_proc:

//------------------------------------------------

autoload(transform::ztrans::lookup):
transform::ztrans::patternFSA:=
loadproc(transform::ztrans::patternFSA, pathname("TRANS","ZTRANS"), "load_patterns"):
autoload(transform::ztrans::addpattern):

transform::ztrans::userpatterns := []:
transform::ztrans::userpatternsFSA := FAIL:

