// expand without using expand
// (transform::ztrans etc. crucially relies on 
// linearity. E.g., patterns are available only 
// for the terms in expanded sums. However, we
// do not want to expand, sin, cos, exp, ln etc.)
// The following library routine just expands
// products and powers with positive integer exponents.

transform::expand:= proc(f, k)
local ss, dummy, s, i, rr, r;
begin
  if not has(f, k) then
     return(f);
  end_if;
  if type(f) = "_mult" then
   [ss, f, dummy]:= split(f, x -> (has(x, k) and
                                   type(x) = "_plus" 
                                  ) or
                                  _lazy_and(
                                     has(x, k),
                                     type(x) = "_power",
                                     type(op(x, 1)) = "_plus",
                                     type(op(x, 2)) = DOM_INT,
                                     op(x, 2) > 1));
  elif type(f) = "_power" and
     has(op(f, 1), k) and
     type(op(f, 1)) = "_plus" and
     type(op(f, 2)) = DOM_INT and
     op(f, 2) > 0 then
     ss:= f;
     f:= 1;
  else
    [ss, f]:= [1, f]:
  end_if;
  if type(ss) = "_mult" then
       ss:= [op(ss)];
       ss:= map(ss, x -> if type(x) = "_power" then
                            op(x, 1) $ op(x, 2)
                         else x end_if);
  elif type(ss) = "_power" then
       ss:= [op(ss, 1) $ op(ss, 2)];
  else ss:= [ss];
  end_if;
  rr:= f;
  if ss <> [1] then
     for i from 1 to nops(ss) do
         if type(rr) = "_plus" then
           rr:= _plus(s*r $ s in ss[i] $ r in rr);
         else
           rr:= _plus(s*rr $ s in ss[i]);
         end_if;
     end_for;
  end_if;
  if type(rr) = "_plus" then
    return(map(rr, transform::expand, k));
  end_if;
  rr;
end_proc:

