//      

/*++
Constant -- expression to test for constant expressions

Constant

This type expressions allows to test for a constant expression.
A constant expression is either a literal constant, an identifier
which is contained in the set 'Type::ConstantIdents' or an
expression where each operand is constant.
++*/

Type::Constant:=

new(Type,
    "Constant",
    proc(t,x)
      option noDebug;
//      local fx;
      name Type::Constant;
    begin
      if args(0) <> 2 or
         contains([DOM_POLY, stdlib::Infinity], domtype(x)) <> 0 then
        return(FALSE)
      end_if;
      // use 'indets' to find identifiers
      if indets(x) minus Type::ConstantIdents <> {} then
        return(FALSE)
      else
        return(TRUE)
      end_if;
//       case domtype(x)
//       of DOM_INT do
//       of DOM_RAT do
//       of DOM_FLOAT do
//       of DOM_COMPLEX do
//       of DOM_INTERVAL do
//          return(TRUE);
//       of DOM_IDENT do
//           return(contains(Type::ConstantIdents, x));
//       end_case;
//       // for short expressions
//       // For DOM_EXPR, try a fast decision via float.
//       // Beware of over/underflows, so use traperror:
//       if traperror((fx:= float(x))) = 0 then
//          case domtype(fx)
//          of DOM_FLOAT do
//          of DOM_COMPLEX do
//             return(TRUE);
//          end_case
//       end_if;
//       case domtype(x)
//       of DOM_EXPR do
//           t:= map([op(x)], testtype, Type::Constant);
//           if contains(t, FALSE) <> 0 then return(FALSE) end_if;
//           if contains(t, FAIL) <> 0 then return(FAIL) end_if;
//           return(TRUE);
//       of DOM_NIL do
//       of DOM_FAIL do
//       of DOM_BOOL do
//       of DOM_NULL do
//       of DOM_STRING do
//          return(TRUE);
//       end_case;
//       FAIL
end_proc,
FALSE, FALSE, "constant"):

Type::ConstantIdents:= { hold(CATALAN), hold(PI), hold(EULER), hold(E), hold(`I`) }:

// end of file 
