// 

/*
ElementOf -- convert a set to a type.

Type::ElementOf(S)

The type expression created returns TRUE if an expression is an
element of the set S.
*/

Type::ElementOf :=
  proc(S)
    option noDebug;
  begin
    if testargs() then
      if domtype(S) <> DOM_SET and S::dom::set2expr = FAIL then
	error("bad type of argument");
      end_if;
    end_if;
    
    new(Type,
	"ElementOf",
        proc(S, t)
	  option noDebug;
	  name Type::ElementOf;
	begin
	  if args(0) <> 2 then
	    return(FALSE);
	  end_if;
	  bool(t in op(S));
	end_proc,
	[S], FALSE);
  end_proc:
  