/*
   Type::Indeterminate - test for identifiers and not constant identifiers
                         (such as PI), or indexed identifiers

   Examples:

>> delete x: testtype(x, Type::Indeterminate)

                             TRUE
>> testtype(x[2], Type::Indeterminate)

                             TRUE
>> testtype(x[sqrt(2)+PI], Type::Indeterminate)

                             TRUE
>> testtype(x[x], Type::Indeterminate)

                             TRUE
>> testtype(PI, Type::Indeterminate)

                             FALSE
>> testtype(PI[1], Type::Indeterminate)

                             TRUE
>> x := 2: testtype(x, Type::Indeterminate)

                             FALSE
>> x := table(): testtype(x[1], Type::Indeterminate)

                             TRUE
>> testtype(3.0, Type::Indeterminate)

                             FALSE
>> testtype(sin(y), Type::Indeterminate)

                             FALSE
*/

Type::Indeterminate := new(Type, "Indeterminate",
  proc(t, x)
    name Type::Indeterminate;
    option noDebug;
  begin
    if args(0) <> 2 then return(FALSE) end_if;

    if domtype(x) = DOM_IDENT then
	not contains(Type::ConstantIdents, x)
    elif type(x) = "_index" then
        bool(domtype(op(x, 1)) = DOM_IDENT)
    else
	FAIL
    end_if;
  end_proc,
  FALSE, FALSE):
