//      

/*++
Intersection -- returns type expression to test simultaneous types

Intersection(T1, T2,...)

T1, T2 - types

The type expression created returns TRUE if an expression has all
of the given types.
++*/

Type::Intersection:=
  proc()
    option noDebug;
    local a, s, e;
  begin
    a:= {args()};
    case nops(a)
      of 0 do error("wrong no of args")
      of 1 do return(op(a))
    end_case;
    
    // test if one of the type arguments is a sequence type 
    s:= FALSE;
    for e in a do
      if Type::isSeqType(e) then s:= TRUE; break end_if
    end_for;
    
    new(Type,
        "Intersection",
        (if map(a, domtype) = {Type} then
           proc(t)
	     name Type::Intersection;
	     option noDebug;
             local e, r, i, x;
           begin
             x:= args(i) $ i=2..args(0);
             r:= TRUE;
             for e in t do
               case extop(e,2)(extop(e,3), x)
                 of FALSE do return(FALSE);
                 of FAIL do return(FAIL);
               end_case;
         end_for;
         r
         end_proc
         else
         proc(t)
	   name Type::Intersection;
           option noDebug;
           local e, r, i,x;
         begin
           x:= args(i) $ i=2..args(0);
           r:= TRUE;
           for e in t do
             case testtype(x, e)
               of FALSE do return(FALSE);
               of FAIL do return(FAIL);
             end_case;
         end_for;
         r
         end_proc
         end_if),
        a, s)
  end_proc:
