/* recognizes an ordinary differential equation in y(z)
  or if y is a set {u,v,...} an ode in u(z), v(z), ... */
Type::ODE := proc(y,z)
  option noDebug;
begin
   if type(y)=DOM_IDENT then y:={y} end_if;
   new(Type,"ODE",subs(proc(l,eq) // l[1] is the function, l[2] the variable 
   local i;
     name Type::ODE;
     option noDebug;
   begin
      case type(eq) 
      of "_mult" do
      of "_equal" do
      of "_power" do
      of "_plus" do
          return(_and((testtype(op(eq,i),Type::ODE(op(l))) $ i=1..nops(eq))))
      of "diff" do
         if not has(op(eq,1),l[1]) then TRUE
         elif contains(l[1],op(eq,[1,0])) and nops(op(eq,1))=1 and op(eq,[1,1])=l[2]
              and {op(eq,2..nops(eq))}={l[2]} then TRUE
         else FALSE
         end_if; break
      otherwise
         if not has(eq,l[1]) then TRUE
         elif type(eq)=DOM_IDENT then FALSE
         elif type(eq)="function" then
            if contains(l[1],op(eq,0)) then
               // bool(nops(eq)=1 and not has(op(eq,1),l[1])) 
		bool(nops(eq)=1 and (op(eq,1)=l[2] or not has(op(eq,1),
			l[1] union {l[2]})))
            elif not has(op(eq,0),l[1]) then
               _and(testtype(op(eq,i),Type::ODE(op(l))) $ i=1..nops(eq))
            elif type(op(eq,0))="D" then
	       stdlib::check_diff(eq,"y","z")
            else FALSE
            end_if
         else _and(testtype(op(eq,i),Type::ODE(op(l))) $ i=1..nops(eq))
         end_if
      end_case
   end_proc,"y"=y,"z"=z),[y,z], FALSE)
end_proc:

// recognizes (D@@n)(y)(z) 
stdlib::check_diff := proc(e,y,z)
       option noDebug;
   begin
      case type(e)
      of "function" do
	    case [type(op(e,0)),nops(op(e,0))]
	    of ["D",1] do return(stdlib::check_diff(subsop(e,0=op(e,[0,1])),y,z))
	    of [DOM_IDENT,1] do return(contains(y,op(e,0)) and
				   (bool(op(e,1)=z) or not has(op(e,1),z)))
	    otherwise FALSE
	    end_case
      of "diff" do return(stdlib::check_diff(op(e,1),y,z))
      otherwise bool(e=z)
      end_case
   end_proc:
