//      

/*++
PolyExpr -- returns type expression to test polynomial expressions

PolyExpr(x [,T])
PolyExpr(l [,T])

x - unknown
l - list of unknowns
T - coefficient type (default is 'Type::AnyType')

The type expression created returns TRUE if an expression is a polynomial
expression with unknown 'x' or unknows 'l' and coefficients of type 'T'.
++*/

Type::PolyExprTestProc:=
proc(t,x)
  local i;
begin
  if args(0) <> 2 then
    return(FALSE)
  end_if;
    
  case type(x)
    of "_plus" do
    of "_mult" do
      for i in op(x) do
        if not Type::PolyExprTestProc(t, i) then
          return(FALSE)
        end_if
      end_for;
      return(TRUE):
    of "_power" do
      i:= op(x,2);
      if domtype(i) = DOM_INT and i > 0 then
        return(Type::PolyExprTestProc(t, op(x,1)))  
      end_if;
      break;
    of DOM_FAIL do
    of DOM_NIL do
    of DOM_STRING do
    of DOM_SET do
    of DOM_LIST do
    of DOM_ARRAY do
    of DOM_TABLE do 
    of DOM_PROC do
    of DOM_FUNC_ENV do
    of DOM_EXEC do 
    of DOM_VAR do
      return(FALSE)
    of DOM_POLY do
      return(Type::PolyExprTestProc(t, expr(x)))  
    otherwise
      if x::dom::hasProp(Cat::Polynomial) = TRUE then
        return(Type::PolyExprTestProc(t, expr(x))) 
      end_if; 
      if contains(t[1], x) > 0 then
        return(TRUE)
      end_if   
  end_case;

  if has(x, t[1]) then
    return(FALSE)
  end_if;

  if nops(t) = 1 then
    testtype(x, Type::Arithmetical) 
  else
    _lazy_or(testtype(x, t[2]), coerce(x, t[2]) <> FAIL) 
  end_if
end_proc:


Type::PolyExpr:=
proc(x,T)
  local p;
begin
  if testargs() then
    case args(0)
      of 1 do break;
      of 2 do
        if Type::isSeqType(T) then
          error("can't test for sequences")
        end_if;
        break;
      otherwise
        error("wrong no of args");
    end_case;
    p:= FAIL;
    if domtype(x) = DOM_LIST then
      if traperror((p:= poly(1,x))) <> 0 then
        error("illegal indeterminate")
      end_if
    elif traperror((p:= poly(1,[x]))) <> 0 then
      error("illegal indeterminate")
    end_if;
    if p = FAIL then
      error("illegal indeterminate")
    end_if;
  end_if;

  new(Type,
      "PolyExpr",
      Type::PolyExprTestProc,
      [(if domtype(x) = DOM_LIST then x else [x] end_if),
       (if args(0) = 2 then T else null() end_if)
       ],
      FALSE)
end_proc:

// end of file 
