//      

/*++
RatExpr -- returns type expression to test rational expressions

RatExpr(x, [,T])

x - unknown
T - coefficient type (default is 'Type::AnyType')

The type expression created returns TRUE if an expression is a rational
expression with unknown 'x' and coefficients of type 'T'.
++*/

Type::RatExpr:= proc(x,T)
    option noDebug;
    local p;
begin
    if testargs() then
        case args(0)
        of 1 do break;
        of 2 do
            if Type::isSeqType(T) then
                error("can't test for sequences")
            end_if;
            break;
        otherwise error("wrong no of args");
        end_case;
        if traperror((p:= poly(1,[x]))) <> 0 then
            error("illegal indeterminate")
        end_if;
        if p = FAIL then
            error("illegal indeterminate")
        end_if;
    end_if;

    new(Type,
	proc()  option noDebug; begin "RatExpr(".expr2text(args()).")" end_proc,
	proc(t,x)
	  name Type::RatExpr;
          local test;
          option escape, noDebug;
	begin
            if args(0) <> 2 then return(FALSE) end_if;
	    test:= proc(x) local o, r; option noDebug; begin
		if x = t[1] then return(TRUE) end_if;
		case type(x)
		of "_plus" do
		of "_mult" do
		    r:= TRUE;
		    for o in x do
			o:= test(o);
			case o
			of FALSE do return(FALSE);
			of FAIL do r:= FAIL;
			end_case;
		    end_for;
		    return(r);

		of "_power" do
		    if domtype(op(x,2)) = DOM_INT then
			return(test(op(x,1)));
		    end_if;
		end_case;
		if has(x, t[1]) then return(FALSE) end_if;
		if nops(t) = 1 then TRUE else testtype(x, t[2]) end_if;
	    end_proc;
	    test:= test(x)
	end_proc,
	[args()], FALSE)
end_proc:
