/*++
Unknown -- expression to test for a variable

Constant

This type expressions allows to test for a variable that may be
used for differentation or integration, for example.
A variable is an identifier (i.e. of type DOM_IDENT ) or an indexed
identifier, where the indices evaluate to numbers (e.g. x[2] ).
++*/

Type::Unknown:=
    new(Type,
	"Unknown",
	proc(t,x)
	  name Type::Unknown;
	  option noDebug;
	begin
	    if args(0) <> 2 then return(FALSE) end_if;
	    case domtype(x)
	    of DOM_IDENT do
		return(TRUE)

	    of DOM_EXPR do
		if op(x,0) = hold(_index) then
		    return(not contains( map({op(x, 2..nops(x))}, testtype, DOM_INT),FALSE ))
		else
		    return( FALSE )
		end_if;

	    end_case;
	    FAIL
	end_proc,
	FALSE, FALSE):

// end of file 
