#!/bin/sh
# $Id$
# 
# install-compr.sh -- install compressed packages.  This is install-tl.sh
# in the `inst' distribution.
# 
# Copyright (c) Thomas Esser, Sebastian Rahtz, 1996, 1997, 1998, 1999,
# 2000, 2001, 2003, 2004, 2005, 2006.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
#    02110-1301, USA.
#     
#    Send bug reports or suggestions to tex-live@tug.org.
#    
# Call this script with a full-featured bourne shell, which may be
#   /bin/sh, /bin/bsh (e.g. AIX-4.XX), /bin/sh5 (e.g. ULTRIX) or
#   /bin/bash (on GNU systems) on your system.

# Modified to allow for inclusion of local schemes along with, or instead of
#   the schemes on the distribution CD. The choice of which to do is a factory
#   option, not a user option. Currently set for local schemes only. 
#   Mount the CD and call from the scrip location with
#     ./install-tl-forswp.sh --ccdir=/CD/mount/path


# set this for debugging...
debug=${OVERRIDE_DEBUG-false}

unset CDPATH  # avoid unwanted output

while test $# -gt 0; do
  case $1 in
    --debug) debug=true;;
    --cddir=*)
          cddir=`echo $1 | sed 's/.*=//'`;;
     *) break;;
  esac
  shift
done

HERE=`cd \`dirname $0 \` && /bin/pwd`
. $HERE/utils.sh
. $HERE/common.sh

series_init()
{
  thisdir=`pwd`
  CDDIR=${cddir-${OVERRIDE_CDDIR-$thisdir}}
  TPM=$CDDIR/texmf/tpm
  PACKAGETPM=$CDDIR/texmf-dist/tpm
  LISTS=$CDDIR/texmf/lists
  test -d $TPM || fatal "$0: $TPM: no such directory. Are you sure this is the TeX Live CD?"

  $echon "Initializing collections... "
  setvars
  systems=`(cd $CDDIR/archive && find . -name "bin-t*.zip" | awk '{FS="."; if(NF==4) print $3}' | sort | uniq)`
  
  cd_schemes=''
  # uncomment the next line to include the CD schemes
  #cd_schemes=`(cd $LISTS && ls *.scheme | sed 's/\.scheme//' | sed 's/-/_/g' | sed 's/$/:/' )`
  local_schemes=`(cd lists && ls *.scheme | sed 's/\.scheme//' | sed 's/-/_/g'| sed 's/$/:/' )`
  all_schemes=`(echo $cd_schemes $local_schemes | sed  's/:/\n/g' | sort -bi -k 1.8 )`
  sc=24
  for s in $all_schemes; do
    S=`echo $s | sed -e 's/_/-/g'`
    sc=`expr $sc + 1`
    eval N=\"\$iden_${sc}\"
    eval SCHEMES_${N}=\"$s\"
    if [ -a $LISTS/$S.scheme ]
    then L=$LISTS
    else L=lists
    fi
    T=`grep '^\*Title' $L/$S.scheme | sed -e 's/\*Title: //'`
    C=`grep '^\*Size'  $L/$S.scheme | sed -e 's/\*Size: //'`
    C=`expr $C / 1000`
    eval schemes_${s}_n=\"$T\"
    eval schemes_${s}_ident=\"$N\"
    eval schemes_${s}_du=\"$C\"
  done

  all_lang_collections=`(cd $LISTS && ls collection-lang* | sed 's/-/_/g' | sort )`
  sc=0
  for s in $all_lang_collections; do
    S=`echo $s | sed 's/_/-/g'`
    sc=`expr $sc + 1`
    eval N=\"\$iden_${sc}\"
    eval LP_${N}=\"$s\"
    T=`grep '^\*Title' $LISTS/$S | sed -e 's/\*Title: //'`
    C=`grep '^\*Size'  $LISTS/$S | sed -e 's/\*Size: //'`
    C=`expr $C / 1000`
    eval p_${s}_n=\"$T\"
    eval p_${s}_ident=\"$N\"
    eval p_${s}_du=\"$C\"
  done

  all_collections=`(cd $LISTS; ls collection-* | grep -v collection-lang |  sed 's/-/_/g' | sort )`
  sc=0
  for s in $all_collections; do
    S=`echo $s | sed 's/_/-/g'`
    sc=`expr $sc + 1`
    eval N=\"\$iden_${sc}\"
    eval P_${N}=\"$s\"
    T=`grep '^\*Title' $LISTS/$S | sed -e 's/\*Title: //'`
    C=`grep '^\*Size'  $LISTS/$S | sed -e 's/\*Size: //'`
    C=`expr $C / 1000`
    eval p_${s}_n=\"$T\"
    eval p_${s}_ident=\"$N\"
    eval p_${s}_du=\"$C\"
    series_select_level $s 0
  done
  scheme_select scheme_swp
  selected_scheme=scheme_swp
  echo "Done initializing collections."
  all_collections_anz=`echo $all_lang_collections $all_collections | awk '{print NF}'`
  systems_init
    total_stat;
}


list_zipped_package()
{
  pack=`echo $1 | sed 's/_/-/g'`
  echo "      package $pack"  >&2
  echo $pack.zip >> $work_dir/extras.list.text
}


# This is run when the user does "I" for a normal disk install.
# 
install_now()
{
   list_file_func=list_zipped_files
   list_package_func=list_zipped_package
  common_start_install
 
  echo "Initializing texmf-var..." >&2
  # additional static config files (pdftexconfig.tex, mktex.cnf, ...).
  (
    cd $TEXDIR/texmf-var || exit 1
    unzip -qq $CDDIR/archive/texmf-var.zip
  )

  echo >&2
  echo "Unpacking zip files for packages..." >&2
  filters=" "
  if test "$opt_source" = X; then
     filters="$filters texmf-dist/source\*"
  fi
  if test "$opt_doc" = X; then
     filters="$filters texmf-dist/doc\*"
  fi
  for f in `sort -u $work_dir/*.list.*`
  do
   $debug || $echon "." >&2
   if test -f $CDDIR/archive/$f
   then
    $debug && echo "  Install files from package/$f" >&2
    (cd $TEXDIR; unzip -o -qq $CDDIR/archive/$f -x $filters)
   fi
   for p in $all_systems; do
     eval \$p_${p}_s || continue
     eval this=\$p_${p}_fn
     P=`echo $p | sed -e 's/_/-/g' ` 
     F=`echo $f | sed 's/\.zip$//'`
     if test -f $CDDIR/archive/$F.$this.zip; then
      $debug && echo "  Install binary programs from archive/$F.$this.zip" >&2
      (cd $TEXDIR; unzip -o -qq $CDDIR/archive/$F.$this.zip)
     else
      $debug && echo "  No $F.$this.zip, skipping binaries for $f" >&2
     fi
  done
 done 
 echo >&2
 echo "Done unpacking." >&2

  common_end_install
}


################################################################
# main()
################################################################
unset TEXCONFIG
init
this_platform_set
screen_1='==================> TeX Live installation procedure <=================

===> Note: Letters/digits in <angle brackets> indicate menu items <===
===>       for commands or configurable options                   <===

    Proposed platform: $this_platform_n
    $warn_nobin
    <P> over-ride system detection and choose platform
    <B> binary systems:        $all_systems_ns out of $all_systems_anz
    <S> Installation scheme ($selected_scheme)
    [customizing installation scheme:
       <C> standard collections   <L> language collections]
    $all_collections_ns out of $all_collections_anz, disk space required: $all_collections_dus kB
    <D> directories:
      TEXDIR      (The main TeX directory)        : $TEXDIR     
      TEXMFLOCAL  (Directory for local styles etc): $TEXMFLOCAL
      TEXMFSYSVAR (Directory for local config)    : $TEXMFSYSVAR
    <O> options:
       [$opt_varfonts] alternate directory for generated fonts ($opt_varfonts_dir)
       [$opt_symlinks] create symlinks in standard directories
       [$opt_doc] do not install macro/font doc tree
       [$opt_source] do not install macro/font source tree
    <I> start installation
    <H> help,  <Q> quit
'
menu_main
