// 

// adt::Heap -- a heap

// implemented from scratch on 14/01/02 by ccr.

alias(parent(i) = (i div 2)):
alias(leftkid(i) = 2*i):
alias(rightkid(i) = 2*i+1):

adt::Heap :=
funcenv(
  proc()
    local H, no_els;
    option escape;
  begin
    H := [[FAIL, FAIL]$16];
    no_els := 0; // number of elements
    
    funcenv(()->null(),
            "Heap",
            table("print" =
//                  (() -> "Heap with ".expr2text(no_els)." elements"),
                  "adt::Heap(...)",
                  "nops" =
                  (() -> no_els),
                  "insert" =
                  proc(cmpval, element)
                    local i;
                  begin
                    i := no_els + 1;
                    if nops(H) < i then
                      H := H.[[FAIL, FAIL]$nops(H)];
                    end_if;
                    while i>1 and H[parent(i)][1] > cmpval do
                      H[i] := H[parent(i)];
                      i := parent(i);
                    end_while;
                    no_els := no_els + 1;
                    H[i] := [cmpval, element];
                  end_proc,
                  "min_element" = (() -> H[1][2]),
                  "min_pair" = (() -> if no_els > 0 then
                                        H[1]
                                      else
                                        FAIL
                                      end_if),
                  "delete_min" =
                  proc()
                    local min_pair, last_pair, i, child;
                  begin
                    if no_els < 1 then
                      return(FAIL);
                    end_if;
                    min_pair := H[1];
                    if no_els = 1 then
                      last_pair := [FAIL, FAIL];
                    else
                      last_pair := H[no_els];
                    end_if;
                    H[no_els] := [FAIL, FAIL];
                    no_els := no_els - 1;
                    i := 1;
                    while leftkid(i) <= no_els do
                      child := leftkid(i);
                      if rightkid(i) <= no_els and
                         H[rightkid(i)][1] < H[leftkid(i)][1] then
                        child := rightkid(i);
                      end_if;
                      if last_pair[1] > H[child][1] then
                        H[i] := H[child];
                      else
                        break;
                      end_if;
                      i := child;
                    end_while;
                    H[i] := last_pair;
                    return(min_pair[2]);
                  end_proc,
                  "H" = (()->H)));
  end_proc,
        NIL,
        table("print" = "adt::Heap")):
  