/*-

bell - compute Bell numbers

Calling Sequence:

   bell(n)

Parameters:

   n -- integer

Synopsis:

   The Bell numbers are defined by the exponential generating function:
   
        exp(exp(x)-1) = sum(bell(n)/n!*x^n, n=0..infinity

   The Bell numbers are computed using the definition :

        bell(0)   = 1  
        bell(n+1) = sum(binomial(n, i)*bell(i), i=0..n)  if n>0

-*/

combinat::bell := proc(n) 
  option remember;
  local c, i, r;
begin
  if testargs() then
     if args(0) <> 1 then
        error("Wrong number of arguments")
     elif not testtype(n, Type::Numeric) then
        if testtype(n, Type::Arithmetical) then
           return(procname(args()))
        else
           error("Nonnegative integer expected")
        end_if
     elif type(n) <> DOM_INT then
        error("Nonnegative integer expected")
     elif n < 0 then
        error("Nonnegative integer expected")
     end_if
  end_if;
     
  if n < 2 then 
     1 
   else
     r := 0; c := 1;
     for i from 0 to n-1 do
         r := r+c*combinat::bell(i);
         c := (c*(n-i-1)) div (i+1)
     end_for;
     r
  end_if
end_proc:
