
// Endliches Kartesisches Produkt endlicher Mengen. 

// n-Tupel werden als Listen realisiert. Dadurch    
// ist diese Operation leider nicht assoziativ:     
/* cartesian( {1,2} , cartesian( {a,b} , {x,y} ) )
 = { [1,[a,x]] , [1,[a,y]] , [1,[b,x]] , [1,[b,y]] ,
     [2,[a,x]] , [2,[a,y]] , [2,[b,x]] , [2,[b,y]] }
<> { [[1,a],x] , [[1,a],y] , [[1,b],x] , [[1,b],y] ,
     [[2,a],x] , [[2,a],y] , [[2,b],x] , [[2,b],y] }
 = cartesian( cartesian( {1,2} , {a,b} ) , {x,y} ) */

// Statt einer Menge kann auch eine natuerliche     
// Zahl N uebergegeben werden, die dann wie die     
// Menge {1,..,N} behandelt wird.                   

combinat::cartesianProduct:=
proc()
  local i, argv: DOM_LIST, res;
begin
  argv:=
  map([args()],
      proc(S)
        // the name is for letting error below use the correct 
        name combinat::cartesianProduct;
      begin
        case type(S)
          of  DOM_INT do
            if S < 0 then
              error("Argument(s) must be set(s) or non-negative integer(s)")
            end_if;
            return([$1..S]); // create a list!
          of DOM_SET do
            return([op(S)]); // convert to list!
          of DOM_LIST do
            return(S)
          otherwise
            error("Argument(s) must be set(s) or non-negative integer(s)") ;
          end_case
        end_proc );
  
  
  case nops(argv)
    of 0 do
      error("Wrong number of arguments")
    of 1 do
      return(map(argv[1], DOM_LIST))
    of 2 do  // Spezialbeschleunigte Routine fuer n=2:
      return(map(argv[2],
                 proc()
                 begin
                   op(map(args(2), DOM_LIST, args(1)))
                 end_proc , [op(argv[1])]))
    otherwise
      res := map(argv[1], DOM_LIST);
      for i in argv[2..nops(argv)] do
        if i = [] then
          return([]);
        end_if;
        res := _concat(op(map(i, X->map(res, append, X))));
      end_for;
      res;
  end_case
end_proc:

