
combinat::compositions:=
proc(n: Type::NonNegInt): DOM_LIST
  local i: DOM_INT, options, types,
  minPart: DOM_INT,
  maxPart: DOM_INT,
  compos,
  composFixedLength;
begin

  compos:=
  proc(n)
    local l;
  begin
    if n=0 then
      return([[]])
    end_if;
    if n < minPart then
      return([])
    end_if;
    [([n-i].l $l in compos(i)) $i= max(0, n-maxPart)..n-minPart]
  end_proc;

  // folowing Knuth, TAOCP, Vol. 4, answer to Question 7.2.1.3.3
  composFixedLength :=
  proc(n, len)
    local i, res, q, r;
  begin
    // normalize to minPart = 0
    n := n - len*minPart;
    if n < 0 then
      return([]);
    end_if;
    
    if len=1 then
      if n + minPart > maxPart then
        return([]);
      else
        return([[n + minPart]]);
      end_if;
    end_if;
    
    q := [0$(len-1), n];
    res := table();
    r := len;
    while nops(res) < options["StopAfter"] do
      if max(q) <= maxPart-minPart then
        // TODO: Skip over them faster
        res[nops(res)] := q;
      end_if;
      if iszero(q[len]) then
        if r = 1 then
          break;
        else
          q[len] := q[r]-1;
          q[r] := 0;
          r := r-1;
        end_if;
      else
        q[len] := q[len] - 1;
        r := len - 1;
      end_if;
      q[r] := q[r] + 1;
    end_while;
    
    [map(res[nops(res) - i], `+`, minPart) $ i = 1..nops(res)];
  end_proc;
  
  options := table(Length = -1,
                   MinPart = 1,
                   MaxPart = max(n, 1),
                   "StopAfter" = infinity // undocumented
                  );
  types := table(Length = Type::PosInt,
                 MinPart = Type::NonNegInt,
                 MaxPart = Type::PosInt,
                 "StopAfter" = Type::Union(Type::PosInt, stdlib::Infinity) // undocumented
        );
  
  options := prog::getOptions(2, [args()], options, TRUE, types)[1];
  minPart:= options[MinPart];
  maxPart:= options[MaxPart];

  if minPart > maxPart then
    error("minimum part is greater than maximum part")
  end_if;
  
  if options[Length] <> -1 then
    composFixedLength(n, options[Length])
  else
    if minPart = 0 then
      error("MinPart zero only allowed for fixed length")
    end_if;
    compos(n, minPart)
  end_if;
    
end_proc:



// deprecated syntax
combinat::composition:=
proc(n, k)
begin
  warning("Syntax deprecated, use combinat::compositions(n, Length = k)");
  combinat::compositions(n, Length = k)
end_proc:
