//    
/*++
Cat::BaseCategory -- the base category 

The Cat::BaseCategory is the base category, any category is a Cat::BaseCategory.
In a Cat::BaseCategory it can be decided if domain elements are equal.
Note that this not necessarily means 'mathematically equal', it
may only mean 'structurally equal'.

The MuPAD expressions (x^2-1)/(x+1) and x-1 are mathematically equal,
but not structurally, for example.

Use the axiom Ax::canonicalRep to state that elements of a domain are
canonically represented by MuPAD expressions, ie. that structural
equality is the same as mathematical equality.

Basic Methods:
equal(x,y)      - returns TRUE iff x and y are equal where x and y are from
		  the 'dom' domain
convert(e)      - converts its arguments to an element of 'dom' or returns
		  FAIL if this is not possible
convert_to(x,T) - converts x (an element of 'dom') to type T or returns
		  FAIL if this is not possible
expr(x)		- converts x (an element of 'dom') to an expression

Methods:
coerce(e)     - converts its argument to an element of 'dom' or returns FAIL
                if this is not possible. The implementation first tries 
                dom::convert(e) and then (domtype(e))::convert_to(e, dom).
new(e,...)    - converts its arguments to an element of 'dom'
print(e)      - returns an expression which is printed as domain element e
testtype(e,T) - tests if e is an element of type T
equiv(x,y)    - returns TRUE iff x and y are equivalent, x or y must
		be of this domain
++*/

category Cat::BaseCategory

   

    convert; convert_to; expr; equal;

    print:= dom::expr;

    TeX:= e->generate::TeX(dom::expr(e));    
    
    new:= proc() begin 
        dom::convert(args());
        if % = FAIL then error("illegal arguments") else % end_if
    end_proc;

    new_extelement:= (if dom::hasProp(Ax::systemRep) then
	proc(d) begin d::new(args(2..args(0))) end_proc 
    else
	FAIL
    end_if);

    coerce:=
    proc(e)
    begin
      if domtype(e) <> dom then
        dom::convert(e);
        if % = FAIL then
          (domtype(e))::convert_to(e, dom)
        else
          %
        end_if
      else
        e
      end_if
    end_proc;
    
  testtype:=
  proc(e, T)
  begin

    if domtype(T)= DomainConstructor then
      return(bool(e::dom::hasProp(T) = TRUE))
    end_if;
    
    if domtype(e) = T then
	    // e is an element of domain T 
        return(TRUE)
    end_if;

    // an object is regarded as an element of a domain T with system
    // representation iff it can be converted
    if domtype(T) = DOM_DOMAIN and T::hasProp(Ax::systemRep) = TRUE then
      return(bool(coerce(e, T) <> FAIL))
    end_if;
    
    FAIL
  end_proc;

  equiv:=
    proc(xx,yy)
      local x,y;
    begin
      x:=xx; y:=yy;
      if domtype(x) = dom then
        if domtype(y) = dom then
          return(dom::equal(x,y))
        end_if;
        y:= dom::convert(y);
      else
        x:= dom::convert(x);
        if domtype(y) <> dom then
          y:= dom::convert(y);
        end_if
      end_if;
      if x = FAIL or y = FAIL then
        FAIL
      else
        dom::equal(x,y)
      end_if
    end_proc;



end_category:

