//    
/*++
Cat::CancellationAbelianMonoid -- the category of abelian monoids with cancellation

An Cat::CancellationAbelianMonoid is a Cat::AbelianMonoid where the cancellation
law holds, ie. a+b = a+c implies b = c.

Methods:-
_subtract(x,y)  - returns z such that y+z = x or FAIL if z dosn't exist. The
	          result is unique due to the cancellation law.
_negate(x)      - returns _subtract(0,x)
intmult(x,i)    - returns x+x+...x (i times) if i is an positive integer, 0 if
	          i=0 and intmult(_negate(x),-i) if i is a negative integer
++*/

category Cat::CancellationAbelianMonoid
    category Cat::AbelianMonoid;

    _subtract;
    
    iszero := if dom::hasProp(Ax::normalRep) then
        Cat::AbelianMonoid::iszero
    else
        toBeDefined
    end_if;

    equal := proc(x,y) begin
	x:= dom::_subtract(x, y);
	if x = FAIL then FALSE else dom::iszero(x) end_if
    end_proc;

    _negate := proc(x) begin dom::_subtract(dom::zero, x) end_proc;

    intmult := domains::repeatedSquaring(dom, "_plus", "zero", "_negate");

begin 

end_category:


