/*   
*/
/*++
Cat::FactorialDomain -- the category of factorial domains (unique factorisation
		   domains)

Please note the following inconsistency: An Dom::Integer is represented
as DOM_INT and factored by 'ifactor'. If 'factor' is called with an
integer it returns that integer unfactored (assuming it is a trivial
polynomial). So the method dom::factor MUST be used to get a
factorization for any factorial domain. Do not rely on overloading!

Methods:
irreducible(x) - returns TRUE iff x is prime
sqrfree(x) - returns the square-free factorisation of x as object of 
             Factored and type "squarefree".
factor(x)  - returns the factorisation of x as an object of Factored and type
             "irreducible".
++*/

category Cat::FactorialDomain
    category Cat::GcdDomain;


    factor;

    sqrfree := proc(xx) local i, j, f, e, x; 
      begin
	x:= dom::factor(xx);
	f:= table();
	for i from 3 to nops(x) step 2 do
	    if contains(f, op(x, i)) then
		f[op(x, i)]:= dom::_mult(f[op(x, i)], op(x, i-1))
	    else
		f[op(x, i)]:= op(x, i-1)
	    end_if;
	end_for;
	e:= sort(map([op(f)], op, 1));
	Factored::create( [op(x, 1), (f[e[j]], e[j]) $ j=1..nops(e) ],"squarefree",dom )
    end_proc;

    irreducible := proc(xx)
        local x;

    begin
	x:= dom::factor(xx);
	if nops(x) = 3 then
	    if op(x, 3) = 1 then
		return(TRUE)
	    end_if
	end_if;
	FALSE
    end_proc;

begin

end_category:
