//    
/*++
Cat::Field -- the category of fields

A Cat::Field is a Cat::SkewField and a Cat::EuclideanDomain. As such it has a commutative
'*' from Cat::EuclideanDomain and an invertible '*' from Cat::SkewField.

Methods:
euclideanDegree(x) - returns the euclidean degree of x; here 0 iff x is
                     0 and 1 otherwise
quo(x,y)           - returns the euclidean quotient of x and y; here q such
                     that x = q * y, ie. x * y^(-1)
rem(x,y)           - returns the euclidean reminder of x and y; here always 0
unitNormal(x)      - returns the unit normal part of x; here 0 iff x is 0 and 1
                     otherwise
unitNormalRep(x)   - returns the unit normal rep., here [1,1/x,x] if x <> 0
		     and [0,0,0] if x = 0
idealGenerator(x1,...,xn) - returns a generator of the ideal defined
		     by the elements x1,...,xn, ie. 0 or 1
irreducible(x)	   - returns FALSE
factor(x)	   - returns [x]
sqrfree(x)	   - returns [x]
++*/

category Cat::Field
    category Cat::EuclideanDomain, Cat::FactorialDomain, Cat::SkewField ;
    axiom Ax::canonicalUnitNormal, Ax::closedUnitNormals ;

    isUnit := not dom::iszero;

    _divide := proc(x,y) begin
        if iszero(y) then error("division by zero") end_if;
        dom::_mult(x, _invert(y))
    end_proc;

    divides := proc(y /*,x*/) begin
	if dom::iszero(y) then error("division by zero") end_if;
	TRUE
    end_proc;

    associates := proc(x,y) begin
	if dom::iszero(x) or dom::iszero(y) then FALSE else TRUE end_if
    end_proc;

    euclideanDegree := proc(x)
    begin
        if dom::iszero(x) then 0 else 1 end_if
    end_proc;
 
    quo := dom::_divide;

    rem := dom::zero;

    divide := proc(x,y) begin (dom::_divide(x,y), dom::zero) end_proc;

    unitNormal := proc(x)
    begin
        if dom::iszero(x) then dom::zero else dom::one end_if
    end_proc;

    unitNormalRep := proc(x)
    begin
	if dom::iszero(x) then
	    [dom::zero, dom::one, dom::one]
	else
	    [dom::one, dom::_invert(x), x]
	end_if
    end_proc;

    gcd :=
    proc()
    begin
      if nops(select([args()], not iszero)) = 0 then
	    dom::zero 
      else
        dom::one
      end_if
    end_proc;

    irreducible := FALSE;

    factor := x -> Factored::create( [x],"irreducible",dom );

    sqrfree := dom::factor;

begin

end_category:
