/*   
*/
/*++
Cat::GcdDomain -- the category of integral domains with a gcd

A Cat::GcdDomain is an Cat::IntegralDomain with a gcd. The axioms for the gcd are:
i)	_divide(x, gcd(x,y)) <> FAIL
ii)	_divide(y, gcd(x,y)) <> FAIL
iii)	_divide(x,z) <> FAIL and _divide(y,z) <> FAIL =>
		_divide(z, gcd(x,y)) <> FAIL
iv)	Ax::canonicalUnitNormal => gcd(x,y) = gcd(y,x)

Methods:
gcd(x1,x2,...) - returns the gcd of x1,x2,...
lcm(x1,x2,...) - returns the lcm of x1,x2,...
++*/

category Cat::GcdDomain
    category Cat::IntegralDomain;

    gcd;

    lcm := proc(x,yy) local y; begin
	case args(0)
	of 2 do y:=yy; break;
	of 1 do return(dom::gcd(x));
	of 0 do return(dom::one);
	otherwise y:= dom::lcm(args(2..args(0)));
	end_case;
	dom::_mult(x, dom::_divide(y, dom::gcd(x, y)))
    end_proc;

begin

end_category:
