     //    
     /*++
     Cat::Module -- the category of R-modules

     Cat::Module(R)

     R - a Cat::CommutativeRing

     A Cat::Module is a Cat::LeftModule and a Cat::RightModule over a commutative
     ring R, thus the multiplication '*' must have two signatures
     '*' : (this,R) -> this and '*' : (R,this) -> this.

     Beware: If a Cat::SemiGroup is also a Cat::Module the multiplication '*'
     has even more signatures: '*' : (this,this) -> this.
     The implementation of the multiplication must handle this. The same
     kind of problem is occuring if a domain is a Cat::Module over more
     than one rng.

     Methods:-
     _mult(x,r) - returns the multiplikation x*r of x by the rng element r
     _mult(r,x) - returns the multiplikation r*x of x by the rng element r
     ++*/

     category Cat::Module( R )
         category Cat::LeftModule(R), Cat::RightModule(R);
         
begin
     if args(0) <> 1 then error("wrong no of args") end_if;
     if not R::hasProp(Cat::CommutativeRing) then
      error("no commutative ring")
     end_if;
end_category:


