//    
/*++
Cat::Monoid -- the category of monoids

A Cat::Monoid is a Cat::SemiGroup with a neutral element "one" according to the
operation '*'.

Entries:-
one         - the neutral element according to '_mult'

Methods:-
_invert(x)  - returns FAIL or a y such that x*y = y*x = 1
_power(x,i) - returns x*x*...*x (i times) for a positive integer i,
	      one for i=0 and _power(_invert(x), -i) if x is a negative integer
isone(x)    - returns TRUE, if x is the neutral element
++*/

category Cat::Monoid
    category Cat::SemiGroup ;

    one; _invert;

    isone := if dom::hasProp(Ax::normalRep) then
		   proc() begin bool(args(1)=dom::one) end_proc 
	       else
		   proc() begin bool(dom::equal(args(1),dom::one)) end_proc 
	       end_if;

    _power := domains::repeatedSquaring(dom, "_mult", "one", "_invert");
    
begin

end_category:

