//    
/*++
Cat::PartialDifferentialRing -- the category of partial differential rings

Cat::PartialDifferentialRing

A partial differential ring is a commutative ring with a finite set
of derivation operators. The derivations are supposed to commute.
They have to be written as follows:

	D([i], f)	ith partial derivation of f

The derivations should return 0 if there is no ith indeterminate of f.

One may further get multiple partial derivations of an element f by:

	D([i1,...,in], f)
	D([], f)

where D([i1,...in], f) is equal to D([i1],...D([in],f)...) and
D([], f) is equal to f.

For most partial differential rings the derivations are differentiations
with respect to some indeterminates, thus in order to support a
natural notion it is also supposed that a method 'diff' exists with:

	diff(f, x)	partial derivation of f with respect to x

This also should should return 0 if there is no indeterminate x of f.
Further diff should support multiple partial derivations:

	diff(f, x1,...,xn)
	diff(f)

where diff(f, x1,...,xn) is equal to diff(...diff(f, x1),...xn) and
diff(f) is equal to f.
++*/

category Cat::PartialDifferentialRing

    category Cat::CommutativeRing;

    D; diff;

begin
  if args(0) <> 0 then error("wrong no of args") end_if
end_category:

