//    
/*++
Cat::RightModule -- the category of right-R-modules

Cat::RightModule(R)

R - a Cat::Ring

A Cat::RightModule is a Cat::AbelianGroup together with a Cat::Ring R with an
right multiplikation '*' : (this,R) -> this.

Axioms for ring elements a, b and module elements x, y:
	x * (a * b) = (x * a) * b
	x * (a + b) = x * a + x * b
	(x + y) * a = x * a + y * a

Beware: If a Cat::SemiGroup is also a Cat::RightModule the multiplication '*'
has 2 signatures: '*' : (this,this) -> this and '*' : (this,R) -> this.
The implementation of the multiplication must handle this. The same
kind of problem is occuring if a domain is a Cat::Module over more
than one rng.

Methods:-
_mult(x,r) - returns the right multiplikation x*r of x by the rng element r
++*/

category Cat::RightModule( R )
    category Cat::AbelianGroup ;
    
    _mult;

begin
     if args(0) <> 1 then error("wrong no of args") end_if;
     if not R::hasProp(Cat::Ring) then error("no ring") end_if;
end_category:
