//    

/*++
TeX -- returns string with axiom constructor in (La)TeX format

TeX(D)

D - axiom or axiom constructor
++*/

AxiomConstructor::TeX:= proc(AC): DOM_STRING
    option noDebug;
    local str, texstr;
begin
    if domtype(AC) <> AxiomConstructor then
        if domtype(AC) <> Axiom then
            error("no axiom constructor")
        end_if;
        AC:= extop(AC,1);
    end_if;
    AC:= extop(AC,1);

    texstr:= proc(x) begin
        if x = "" then "" else
            _concat(op(subs(text2list(x,["_"]), "_"="\\_")))
        end_if
    end_proc;

    // header 
    str:= "\n\\begin{muAxiom}{".expr2text(op(AC,6)).
          "}{% short description\n}\n\n";

    // syntax 
    if op(AC,1) = NIL then
        str:= str."\\muConstSyntax{}\n\n";
    else
        str:= str."\\muSyntax{".texstr(expr2text(op(AC,1)))."}\n\n";
    end_if;

    str."% axiom description\n\n\\end{muAxiom}\n\n"
end_proc:

// end of file 
