/*   
*/
/*++
AxiomConstructor -- the domain of axiom constructors

Axiom constructors are used to create axioms depending upon
parameters.  (Axioms are elements of the domain 'Axiom'.)

Normally no methods of the domain 'AxiomConstructor' are
called by the axiom constructor implementor. All methods are
called implicitly.

An axiom constructor is an element of AxiomConstructor with the
following operands:

0 - the domain AxiomConstructor
1 - the init-procedure of the constructor (a procedure)
2 - a domain containing the axioms constructed so far

Axiom instances are created by the method 'func_call'. The initialization
procedure (op 1) is called with the actual parameters and is used to
create the closure of the axiom.
++*/

AxiomConstructor:= newDomain("AxiomConstructor"):
AxiomConstructor::info:= "Domain 'AxiomConstructor'":
AxiomConstructor::interface:= {}:
AxiomConstructor::create_dom:= hold(AxiomConstructor):
AxiomConstructor::subs:= x -> x:

alias(path = pathname("DOMAINS", "CONSTR")):

AxiomConstructor::func_call:= loadproc(AxiomConstructor::func_call, path, "ACfcall"):
AxiomConstructor::print:= loadproc(AxiomConstructor::print, path, "ACprint"):
AxiomConstructor::create_dom_elem:= loadproc(AxiomConstructor::create_dom_elem, path, "ACprint"):
AxiomConstructor::testtype:= loadproc(AxiomConstructor::testtype, path, "ACttype"):
AxiomConstructor::TeX:= loadproc(AxiomConstructor::TeX, path, "ACtex"):
AxiomConstructor::printInfo:= loadproc(AxiomConstructor::printInfo, path, "ACprInfo"):

// end of file 

