//    

/*++
entryOrigins -- get list of all categories which define entry as 'toBeDefined'

entryOrigins(Dom,e)

Dom - domain of entry
e    - entry name

Returns either a list containing all categories of 'Dom' which define
entry 'e' as 'toBeDefined' or the last category which defines the
entry if there is no category which defines it as 'toBeDefined'.
(These are the categories supposed to define the meaning of the entry.)

The domain '__dom__' is used as a global variable by 'getNamedEntry' in
order to get the domain for which to create the entry in that method
(too bad, but hides the details to the category implementor).
++*/

CategoryConstructor::entryOrigins:= proc(DOM: DOM_DOMAIN, e: DOM_STRING)
    option noDebug;
    local C, r, i, CL, Cd;
    save __dom__;
begin
    __dom__:= DOM;
    Cd:=NIL;
    CL:= [];
    i:= 1;
    while (C:= DomainConstructor::getCategory(DOM, i)) <> FAIL do
    	i:= i+1;
	// search for entry in category constructor 
	r:= extop(extop(C,1),5);
	if contains(r, e) then
	    // evaluate entry in closure of category 
	    r:= _eval_entry(indexval(r, e), DOM, extop(C,2));

	    if r = hold(toBeDefined) then
		CL:= append(CL, C)
	    elif r <> NIL and r <> null() then
	        Cd:= C
	    end_if
	end_if;
    end_while;
    if CL = [] then
        if Cd = NIL then [] else [Cd] end_if
    else
        CL
    end_if
end_proc:

// end of file 
