//    

/*++
allDomainEntries -- return sets of all entries of domain

allDomainEntries(Dom)

Dom      - domain

Searches for entries in line with makeEntry. Returns a list of 2 sets:
1- the defined entries
2- the entries which have to be defined
++*/

DomainConstructor::allDomainEntries:= proc(DOM: DOM_DOMAIN)
    option noDebug;
    local r, e, d, u, entries;
begin
    r:= NIL;
    u:= {};
    d:= {};
    // search for entries in constructor 
    entries:= extop(DOM::constructor,4);
    for e in entries do
      if op(e,2) = FAIL then next end_if;
      e:= op(e,1);
      if contains(d, e) then next end_if;
      if contains(u, e) then next end_if;
      
      // evaluate entry in closure of domain
//      r:= _eval_entry(indexval(entries, e), DOM, DOM::closure);
      // the slot call makes more or less the same as the above code,
      // but implicitly assigns the result in DOM;  fixes #1754
      r:= slot(DOM, e);

        // toBeDefined means: this entry should have been defined elsewhere 
      if r = hold(toBeDefined) then
        u:= u union {e}
      elif r <> NIL and r <> null() then
        d:= d union {e}
      end_if;
    end_for;
  
    // search for entries in super-domains 
    d:= DomainConstructor::allSuperDomainEntries(DOM, d, u);

    // search for entries in categories 
    CategoryConstructor::allEntries(DOM, op(d));
end_proc:

// end of file 
