//    

/*++
allSuperDomainEntries -- get all entries of super-domains

allSuperDomainEntries(Dom, defined, undefined)

Dom       - domain
defined   - set with defined entries
undefined - set with 'to be defined' entries

Searches for entries in line with getSuperDomainEntry. The names of the
entries are inserted in the sets 'undefined' and 'defined'. Returns
a list with the two sets.
++*/

DomainConstructor::allSuperDomainEntries:= proc(DOM: DOM_DOMAIN,
						d: DOM_SET, u: DOM_SET)
    option noDebug;
    local SD, r, e, entries;
begin
    r := NIL;
    for SD in DOM::super_domains do

	// search for entry in super-domain constructor 
	entries:= extop(SD::constructor,4);
	for e in entries do
	    if op(e,2) = FAIL then next end_if;
	    e:= op(e,1);
	    if contains(d, e) then next end_if;
	    if contains(u, e) then next end_if;

	    // evaluate entry in closure of super-domain 
	    r:= _eval_entry(indexval(entries, e), DOM, SD::closure);

	    // toBeDefined means: this entry should have been defined elsewhere 
	    if r = hold(toBeDefined) then
		u:= u union {e}
	    elif r <> NIL and r <> null() then
		d:= d union {e}
	    end_if;
	end_for;
    end_for;
    [ d, u ]
end_proc:

// end of file 
