//    

/*++
DomainConstructor::getCategory -- get category by index

DomainConstructor::getCategory(Dom, i)

Dom - the domain to get the category of
i    - index

This function is used to iterate the categories of a domain. It returns
the 'i'th category of the domain 'Dom', where the categories of the
categories graph of 'Dom' are orderd in a breath-first manner. FAIL is
returned if less than 'i' categories exist for 'Dom'.

Note that categories are created on demand during the iteration, using the
function DomainConstructor::makeCategory. Categories created so far are
stored in 'Dom::categories', the entry 'Dom::categories_idx' is the index
of the next category for which to create the direct super-categories.

The axioms of 'Dom' defined by the categories are als created as a side-
effect of creating the categories (not very nice).
++*/

DomainConstructor::getCategory:= proc(DOM: DOM_DOMAIN, i: DOM_INT)
    option noDebug;
begin
    if i <= nops(DOM::categories) then
    	DOM::categories[i]
    elif DOM::categories_idx > nops(DOM::categories) then
    	FAIL
    else
    	DomainConstructor::makeCategory(DOM, i)
    end_if
end_proc:

DomainConstructor::makeCategory:= proc(DOM: DOM_DOMAIN, i: DOM_INT)
    option noDebug;
    local C, S, A, j;
begin
    while DOM::categories_idx <= nops(DOM::categories) do
	S:= DOM::categories[DOM::categories_idx];
	for C in extop(extop(S,1),3) do
	    // evaluate category in closure of super-category 
	    C:= _eval_entry(C, DOM, extop(S,2));
	    if C = NIL or C = null() then next end_if;
	    if contains(DOM::categories, C) <> 0 then next end_if;
	    if domtype(C) <> Category then
		error("invalid category")
	    end_if;
	    sysassign(DOM::categories, append(DOM::categories, C));
	    // evaluate axioms in closure of category 
	    A:= extop(extop(C,1),4);
	    A:= { _eval_entry(A[j], DOM, extop(C,2)) $ j=1..nops(A) }
		minus { NIL };
	    if A <> {} then
		if map(A, domtype) <> {Axiom} then
		    error("invalid axiom")
		end_if;
		sysassign(DOM::axioms, DOM::axioms union A);
	    end_if;
	end_for;
	sysassign(DOM::categories_idx, DOM::categories_idx+1);
	if i <= nops(DOM::categories) then 
	    return(DOM::categories[i]) 
	end_if;
    end_while;
    FAIL
end_proc:

// end of file 
